/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentAssert;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecAssert;
import io.fabric8.kubernetes.assertions.HasPodSelectionAssert;
import io.fabric8.kubernetes.assertions.PodSelectionAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import java.util.Map;

public class DeploymentPodsAssert
extends DeploymentAssert
implements HasPodSelectionAssert {
    private final KubernetesClient client;

    public DeploymentPodsAssert(KubernetesClient client, Deployment deployment) {
        super(deployment);
        this.client = client;
    }

    @Override
    public PodSelectionAssert pods() {
        ((DeploymentSpecAssert)this.spec().isNotNull()).selector().isNotNull();
        DeploymentSpec spec = ((Deployment)this.actual).getSpec();
        Integer replicas = spec.getReplicas();
        LabelSelector selector = spec.getSelector();
        Map matchLabels = selector.getMatchLabels();
        List matchExpressions = selector.getMatchExpressions();
        return new PodSelectionAssert(this.client, replicas, matchLabels, matchExpressions, "DeploymentConfig " + KubernetesHelper.getName((HasMetadata)((HasMetadata)this.actual)));
    }
}

