/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.IntOrStringAssert;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractServicePortAssert<S extends AbstractServicePortAssert<S, A>, A extends ServicePort>
extends AbstractAssert<S, A> {
    protected AbstractServicePortAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((ServicePort)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert name() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServicePort)this.actual).getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"), new Object[0]);
    }

    public S hasNodePort(Integer nodePort) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting nodePort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualNodePort = ((ServicePort)this.actual).getNodePort();
        if (!Objects.areEqual((Object)actualNodePort, (Object)nodePort)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodePort, actualNodePort});
        }
        return (S)((Object)((AbstractServicePortAssert)this.myself));
    }

    public S hasPort(Integer port) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualPort = ((ServicePort)this.actual).getPort();
        if (!Objects.areEqual((Object)actualPort, (Object)port)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, port, actualPort});
        }
        return (S)((Object)((AbstractServicePortAssert)this.myself));
    }

    public StringAssert protocol() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServicePort)this.actual).getProtocol()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "protocol"), new Object[0]);
    }

    public IntOrStringAssert targetPort() {
        this.isNotNull();
        return (IntOrStringAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((ServicePort)this.actual).getTargetPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "targetPort"), new Object[0]));
    }
}

