/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.PodTemplateSpecAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentStrategyAssert;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractDeploymentConfigSpecAssert<S extends AbstractDeploymentConfigSpecAssert<S, A>, A extends DeploymentConfigSpec>
extends AbstractAssert<S, A> {
    protected AbstractDeploymentConfigSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DeploymentConfigSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasMinReadySeconds(Integer minReadySeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualMinReadySeconds = ((DeploymentConfigSpec)this.actual).getMinReadySeconds();
        if (!Objects.areEqual((Object)actualMinReadySeconds, (Object)minReadySeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, minReadySeconds, actualMinReadySeconds});
        }
        return (S)((Object)((AbstractDeploymentConfigSpecAssert)this.myself));
    }

    public BooleanAssert paused() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DeploymentConfigSpec)this.actual).getPaused()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "paused"), new Object[0]);
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((DeploymentConfigSpec)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractDeploymentConfigSpecAssert)this.myself));
    }

    public S hasRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting revisionHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualRevisionHistoryLimit = ((DeploymentConfigSpec)this.actual).getRevisionHistoryLimit();
        if (!Objects.areEqual((Object)actualRevisionHistoryLimit, (Object)revisionHistoryLimit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, revisionHistoryLimit, actualRevisionHistoryLimit});
        }
        return (S)((Object)((AbstractDeploymentConfigSpecAssert)this.myself));
    }

    public MapAssert selector() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DeploymentConfigSpec)this.actual).getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"), new Object[0]);
    }

    public DeploymentStrategyAssert strategy() {
        this.isNotNull();
        return (DeploymentStrategyAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((DeploymentConfigSpec)this.actual).getStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strategy"), new Object[0]);
    }

    public PodTemplateSpecAssert template() {
        this.isNotNull();
        return (PodTemplateSpecAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((DeploymentConfigSpec)this.actual).getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"), new Object[0]);
    }

    public BooleanAssert test() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DeploymentConfigSpec)this.actual).getTest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "test"), new Object[0]);
    }

    public NavigationListAssert<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert> triggers() {
        this.isNotNull();
        AssertFactory<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert> assertFactory = new AssertFactory<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert>(){

            @Override
            public DeploymentTriggerPolicyAssert createAssert(DeploymentTriggerPolicy t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert> answer = new NavigationListAssert<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert>(((DeploymentConfigSpec)this.actual).getTriggers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "triggers"), new Object[0]);
        return answer;
    }
}

