/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert;
import io.fabric8.kubernetes.api.model.ObjectMetaAssert;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceAssert;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;

public abstract class AbstractServiceAccountAssert<S extends AbstractServiceAccountAssert<S, A>, A extends ServiceAccount>
extends AbstractAssert<S, A> {
    protected AbstractServiceAccountAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((ServiceAccount)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert apiVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceAccount)this.actual).getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"), new Object[0]);
    }

    public BooleanAssert automountServiceAccountToken() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((ServiceAccount)this.actual).getAutomountServiceAccountToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "automountServiceAccountToken"), new Object[0]);
    }

    public NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> imagePullSecrets() {
        this.isNotNull();
        AssertFactory<LocalObjectReference, LocalObjectReferenceAssert> assertFactory = new AssertFactory<LocalObjectReference, LocalObjectReferenceAssert>(){

            @Override
            public LocalObjectReferenceAssert createAssert(LocalObjectReference t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> answer = new NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert>(((ServiceAccount)this.actual).getImagePullSecrets(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imagePullSecrets"), new Object[0]);
        return answer;
    }

    public StringAssert kind() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceAccount)this.actual).getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"), new Object[0]);
    }

    public ObjectMetaAssert metadata() {
        this.isNotNull();
        return (ObjectMetaAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((ServiceAccount)this.actual).getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"), new Object[0]);
    }

    public NavigationListAssert<ObjectReference, ObjectReferenceAssert> secrets() {
        this.isNotNull();
        AssertFactory<ObjectReference, ObjectReferenceAssert> assertFactory = new AssertFactory<ObjectReference, ObjectReferenceAssert>(){

            @Override
            public ObjectReferenceAssert createAssert(ObjectReference t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<ObjectReference, ObjectReferenceAssert> answer = new NavigationListAssert<ObjectReference, ObjectReferenceAssert>(((ServiceAccount)this.actual).getSecrets(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secrets"), new Object[0]);
        return answer;
    }
}

