/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.JobCondition;
import io.fabric8.kubernetes.api.model.JobConditionAssert;
import io.fabric8.kubernetes.api.model.JobStatus;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractJobStatusAssert<S extends AbstractJobStatusAssert<S, A>, A extends JobStatus>
extends AbstractAssert<S, A> {
    protected AbstractJobStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasActive(Integer active) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting active of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualActive = ((JobStatus)this.actual).getActive();
        if (!Objects.areEqual((Object)actualActive, (Object)active)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, active, actualActive});
        }
        return (S)((Object)((AbstractJobStatusAssert)this.myself));
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((JobStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert completionTime() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((JobStatus)this.actual).getCompletionTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "completionTime"), new Object[0]);
    }

    public NavigationListAssert<JobCondition, JobConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<JobCondition, JobConditionAssert> assertFactory = new AssertFactory<JobCondition, JobConditionAssert>(){

            @Override
            public JobConditionAssert createAssert(JobCondition t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<JobCondition, JobConditionAssert> answer = new NavigationListAssert<JobCondition, JobConditionAssert>(((JobStatus)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public S hasFailed(Integer failed) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting failed of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualFailed = ((JobStatus)this.actual).getFailed();
        if (!Objects.areEqual((Object)actualFailed, (Object)failed)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, failed, actualFailed});
        }
        return (S)((Object)((AbstractJobStatusAssert)this.myself));
    }

    public StringAssert startTime() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((JobStatus)this.actual).getStartTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTime"), new Object[0]);
    }

    public S hasSucceeded(Integer succeeded) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting succeeded of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualSucceeded = ((JobStatus)this.actual).getSucceeded();
        if (!Objects.areEqual((Object)actualSucceeded, (Object)succeeded)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, succeeded, actualSucceeded});
        }
        return (S)((Object)((AbstractJobStatusAssert)this.myself));
    }
}

