/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorAssert;
import io.fabric8.kubernetes.api.model.PodTemplateSpecAssert;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractDaemonSetSpecAssert<S extends AbstractDaemonSetSpecAssert<S, A>, A extends DaemonSetSpec>
extends AbstractAssert<S, A> {
    protected AbstractDaemonSetSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DaemonSetSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasMinReadySeconds(Integer minReadySeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualMinReadySeconds = ((DaemonSetSpec)this.actual).getMinReadySeconds();
        if (!Objects.areEqual((Object)actualMinReadySeconds, (Object)minReadySeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, minReadySeconds, actualMinReadySeconds});
        }
        return (S)((Object)((AbstractDaemonSetSpecAssert)this.myself));
    }

    public S hasRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting revisionHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualRevisionHistoryLimit = ((DaemonSetSpec)this.actual).getRevisionHistoryLimit();
        if (!Objects.areEqual((Object)actualRevisionHistoryLimit, (Object)revisionHistoryLimit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, revisionHistoryLimit, actualRevisionHistoryLimit});
        }
        return (S)((Object)((AbstractDaemonSetSpecAssert)this.myself));
    }

    public LabelSelectorAssert selector() {
        this.isNotNull();
        return (LabelSelectorAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((DaemonSetSpec)this.actual).getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"), new Object[0]);
    }

    public PodTemplateSpecAssert template() {
        this.isNotNull();
        return (PodTemplateSpecAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((DaemonSetSpec)this.actual).getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"), new Object[0]);
    }

    public S hasTemplateGeneration(Long templateGeneration) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting templateGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualTemplateGeneration = ((DaemonSetSpec)this.actual).getTemplateGeneration();
        if (!Objects.areEqual((Object)actualTemplateGeneration, (Object)templateGeneration)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, templateGeneration, actualTemplateGeneration});
        }
        return (S)((Object)((AbstractDaemonSetSpecAssert)this.myself));
    }

    public DaemonSetUpdateStrategyAssert updateStrategy() {
        this.isNotNull();
        return (DaemonSetUpdateStrategyAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((DaemonSetSpec)this.actual).getUpdateStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "updateStrategy"), new Object[0]);
    }
}

