/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.PolicyRule;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractClusterRoleAssert<S extends AbstractClusterRoleAssert<S, A>, A extends ClusterRole>
extends AbstractAssert<S, A> {
    protected AbstractClusterRoleAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ClusterRole)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }

    public S hasApiVersion(ClusterRole.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ClusterRole.ApiVersion actualApiVersion = ((ClusterRole)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((ClusterRole)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }

    public S hasMetadata(ObjectMeta metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectMeta actualMetadata = ((ClusterRole)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }

    public S hasRules(PolicyRule ... rules) {
        this.isNotNull();
        if (rules == null) {
            this.failWithMessage("Expecting rules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ClusterRole)this.actual).getRules(), (Object[])rules);
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }

    public S hasOnlyRules(PolicyRule ... rules) {
        this.isNotNull();
        if (rules == null) {
            this.failWithMessage("Expecting rules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((ClusterRole)this.actual).getRules(), (Object[])rules);
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }

    public S doesNotHaveRules(PolicyRule ... rules) {
        this.isNotNull();
        if (rules == null) {
            this.failWithMessage("Expecting rules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((ClusterRole)this.actual).getRules(), (Object[])rules);
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }

    public S hasNoRules() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have rules but had :\n  <%s>";
        if (((ClusterRole)this.actual).getRules().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ClusterRole)this.actual).getRules()});
        }
        return (S)((Object)((AbstractClusterRoleAssert)this.myself));
    }
}

