/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableLabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluent;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LabelSelectorRequirementBuilder
extends LabelSelectorRequirementFluentImpl<LabelSelectorRequirementBuilder>
implements VisitableBuilder<LabelSelectorRequirement, LabelSelectorRequirementBuilder> {
    LabelSelectorRequirementFluent<?> fluent;

    public LabelSelectorRequirementBuilder() {
        this(new LabelSelectorRequirement());
    }

    public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent) {
        this(fluent, new LabelSelectorRequirement());
    }

    public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent, LabelSelectorRequirement instance) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withOperator(instance.getOperator());
        fluent.withValues(instance.getValues());
    }

    public LabelSelectorRequirementBuilder(LabelSelectorRequirement instance) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withOperator(instance.getOperator());
        this.withValues(instance.getValues());
    }

    public EditableLabelSelectorRequirement build() {
        EditableLabelSelectorRequirement buildable = new EditableLabelSelectorRequirement(this.fluent.getKey(), this.fluent.getOperator(), this.fluent.getValues());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorRequirementBuilder that = (LabelSelectorRequirementBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

