/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodSecurityContextFluentImpl<T extends PodSecurityContextFluent<T>>
extends BaseFluent<T>
implements PodSecurityContextFluent<T> {
    Long fsGroup;
    Boolean runAsNonRoot;
    Long runAsUser;
    VisitableBuilder<SELinuxOptions, ?> seLinuxOptions;
    List<Long> supplementalGroups = new ArrayList<Long>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PodSecurityContextFluentImpl() {
    }

    public PodSecurityContextFluentImpl(PodSecurityContext instance) {
        this.withFsGroup(instance.getFsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSupplementalGroups(instance.getSupplementalGroups());
    }

    @Override
    public Long getFsGroup() {
        return this.fsGroup;
    }

    @Override
    public T withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (T)this;
    }

    @Override
    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public T withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (T)this;
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public T withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (T)this;
    }

    @Override
    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? (SELinuxOptions)this.seLinuxOptions.build() : null;
    }

    @Override
    public T withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.add(this.seLinuxOptions);
        }
        return (T)this;
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<T> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<T> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public T withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    @Override
    public T addToSupplementalGroups(Long ... items) {
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromSupplementalGroups(Long ... items) {
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @Override
    public T withSupplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups.clear();
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withSupplementalGroups(Long ... supplementalGroups) {
        this.supplementalGroups.clear();
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl)o;
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SeLinuxOptionsNestedImpl<N>
    extends SELinuxOptionsFluentImpl<PodSecurityContextFluent.SeLinuxOptionsNested<N>>
    implements PodSecurityContextFluent.SeLinuxOptionsNested<N> {
        private final SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl() {
            this.builder = new SELinuxOptionsBuilder(this);
        }

        SeLinuxOptionsNestedImpl(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }
    }
}

