/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableRouteSpec;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.RouteSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RouteSpecBuilder
extends RouteSpecFluentImpl<RouteSpecBuilder>
implements VisitableBuilder<RouteSpec, RouteSpecBuilder> {
    RouteSpecFluent<?> fluent;

    public RouteSpecBuilder() {
        this(new RouteSpec());
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent) {
        this(fluent, new RouteSpec());
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withPath(instance.getPath());
        fluent.withTls(instance.getTls());
        fluent.withTo(instance.getTo());
    }

    public RouteSpecBuilder(RouteSpec instance) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
    }

    public EditableRouteSpec build() {
        EditableRouteSpec buildable = new EditableRouteSpec(this.fluent.getHost(), this.fluent.getPath(), this.fluent.getTls(), this.fluent.getTo());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteSpecBuilder that = (RouteSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

