/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.PolicyRule;
import io.fabric8.openshift.api.model.Role;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractRoleAssert<S extends AbstractRoleAssert<S, A>, A extends Role>
extends AbstractAssert<S, A> {
    protected AbstractRoleAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((Role)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractRoleAssert)this.myself));
    }

    public S hasApiVersion(Role.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Role.ApiVersion actualApiVersion = ((Role)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractRoleAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((Role)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractRoleAssert)this.myself));
    }

    public S hasMetadata(ObjectMeta metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectMeta actualMetadata = ((Role)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractRoleAssert)this.myself));
    }

    public S hasRules(PolicyRule ... rules) {
        this.isNotNull();
        if (rules == null) {
            throw new AssertionError((Object)"Expecting rules parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Role)this.actual).getRules(), (Object[])rules);
        return (S)((Object)((AbstractRoleAssert)this.myself));
    }

    public S hasNoRules() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have rules but had :\n  <%s>";
        if (((Role)this.actual).getRules().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Role)this.actual).getRules()});
        }
        return (S)((Object)((AbstractRoleAssert)this.myself));
    }
}

