/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableTLSConfig;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigFluent;
import io.fabric8.openshift.api.model.TLSConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TLSConfigBuilder
extends TLSConfigFluentImpl<TLSConfigBuilder>
implements VisitableBuilder<TLSConfig, TLSConfigBuilder> {
    TLSConfigFluent<?> fluent;

    public TLSConfigBuilder() {
        this(new TLSConfig());
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent) {
        this(fluent, new TLSConfig());
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, TLSConfig instance) {
        this.fluent = fluent;
        fluent.withCaCertificate(instance.getCaCertificate());
        fluent.withCertificate(instance.getCertificate());
        fluent.withDestinationCACertificate(instance.getDestinationCACertificate());
        fluent.withKey(instance.getKey());
        fluent.withTermination(instance.getTermination());
    }

    public TLSConfigBuilder(TLSConfig instance) {
        this.fluent = this;
        this.withCaCertificate(instance.getCaCertificate());
        this.withCertificate(instance.getCertificate());
        this.withDestinationCACertificate(instance.getDestinationCACertificate());
        this.withKey(instance.getKey());
        this.withTermination(instance.getTermination());
    }

    public EditableTLSConfig build() {
        EditableTLSConfig buildable = new EditableTLSConfig(this.fluent.getCaCertificate(), this.fluent.getCertificate(), this.fluent.getDestinationCACertificate(), this.fluent.getKey(), this.fluent.getTermination());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSConfigBuilder that = (TLSConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

