/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Capabilities;
import io.fabric8.kubernetes.api.model.CapabilitiesBuilder;
import io.fabric8.kubernetes.api.model.CapabilitiesFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluent;
import java.util.HashMap;
import java.util.Map;

public class SecurityContextFluent<T extends SecurityContextFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    VisitableBuilder<Capabilities, ?> capabilities;
    Boolean privileged;
    Boolean runAsNonRoot;
    Long runAsUser;
    VisitableBuilder<SELinuxOptions, ?> seLinuxOptions;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Capabilities getCapabilities() {
        return this.capabilities != null ? (Capabilities)this.capabilities.build() : null;
    }

    public T withCapabilities(Capabilities capabilities) {
        if (capabilities != null) {
            this.capabilities = new CapabilitiesBuilder(capabilities);
            this._visitables.add(this.capabilities);
        }
        return (T)((Object)this);
    }

    public CapabilitiesNested<T> withNewCapabilities() {
        return new CapabilitiesNested();
    }

    public CapabilitiesNested<T> withNewCapabilitiesLike(Capabilities item) {
        return new CapabilitiesNested(item);
    }

    public CapabilitiesNested<T> editCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities());
    }

    public Boolean isPrivileged() {
        return this.privileged;
    }

    public T withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (T)((Object)this);
    }

    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public T withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (T)((Object)this);
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public T withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (T)((Object)this);
    }

    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? (SELinuxOptions)this.seLinuxOptions.build() : null;
    }

    public T withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.add(this.seLinuxOptions);
        }
        return (T)((Object)this);
    }

    public SeLinuxOptionsNested<T> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNested();
    }

    public SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNested(item);
    }

    public SeLinuxOptionsNested<T> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    public T withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SecurityContextFluent that = (SecurityContextFluent)((Object)o);
        if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SeLinuxOptionsNested<N>
    extends SELinuxOptionsFluent<SeLinuxOptionsNested<N>>
    implements Nested<N> {
        private final SELinuxOptionsBuilder builder;

        SeLinuxOptionsNested() {
            this.builder = new SELinuxOptionsBuilder(this);
        }

        SeLinuxOptionsNested(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        public N endSeLinuxOptions() {
            return this.and();
        }

        public N and() {
            return (N)SecurityContextFluent.this.withSeLinuxOptions(this.builder.build());
        }
    }

    public class CapabilitiesNested<N>
    extends CapabilitiesFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        private final CapabilitiesBuilder builder;

        CapabilitiesNested(Capabilities item) {
            this.builder = new CapabilitiesBuilder(this, item);
        }

        CapabilitiesNested() {
            this.builder = new CapabilitiesBuilder(this);
        }

        public N endCapabilities() {
            return this.and();
        }

        public N and() {
            return (N)SecurityContextFluent.this.withCapabilities(this.builder.build());
        }
    }
}

