/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeClaimSpecFluent<T extends PersistentVolumeClaimSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<String> accessModes = new ArrayList<String>();
    VisitableBuilder<ResourceRequirements, ?> resources;
    String volumeName;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (T)((Object)this);
    }

    public T removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (T)((Object)this);
    }

    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public T withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)((Object)this);
    }

    public T withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)((Object)this);
    }

    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)((Object)this);
    }

    public ResourcesNested<T> withNewResources() {
        return new ResourcesNested();
    }

    public ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public T withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (T)((Object)this);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimSpecFluent that = (PersistentVolumeClaimSpecFluent)((Object)o);
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNested() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N endResources() {
            return this.and();
        }

        public N and() {
            return (N)PersistentVolumeClaimSpecFluent.this.withResources(this.builder.build());
        }
    }
}

