/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.BuildSpecFluent;
import io.fabric8.openshift.api.model.EditableBuildSpec;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildSpecBuilder
extends BuildSpecFluent<BuildSpecBuilder>
implements VisitableBuilder<BuildSpec, BuildSpecBuilder> {
    BuildSpecFluent<?> fluent;

    public BuildSpecBuilder() {
        this(new BuildSpec());
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent) {
        this(fluent, new BuildSpec());
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent, BuildSpec instance) {
        this.fluent = fluent;
        fluent.withOutput(instance.getOutput());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
    }

    public BuildSpecBuilder(BuildSpec instance) {
        this.fluent = this;
        this.withOutput(instance.getOutput());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
    }

    public EditableBuildSpec build() {
        EditableBuildSpec buildable = new EditableBuildSpec(this.fluent.getOutput(), this.fluent.getResources(), this.fluent.getRevision(), this.fluent.getServiceAccount(), this.fluent.getSource(), this.fluent.getStrategy());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSpecBuilder that = (BuildSpecBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

