/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableMetadataFile;
import io.fabric8.kubernetes.api.model.MetadataFile;
import io.fabric8.kubernetes.api.model.MetadataFileFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MetadataFileBuilder
extends MetadataFileFluent<MetadataFileBuilder>
implements VisitableBuilder<MetadataFile, MetadataFileBuilder> {
    MetadataFileFluent<?> fluent;

    public MetadataFileBuilder() {
        this(new MetadataFile());
    }

    public MetadataFileBuilder(MetadataFileFluent<?> fluent) {
        this(fluent, new MetadataFile());
    }

    public MetadataFileBuilder(MetadataFileFluent<?> fluent, MetadataFile instance) {
        this.fluent = fluent;
        fluent.withFieldRef(instance.getFieldRef());
        fluent.withName(instance.getName());
    }

    public MetadataFileBuilder(MetadataFile instance) {
        this.fluent = this;
        this.withFieldRef(instance.getFieldRef());
        this.withName(instance.getName());
    }

    public EditableMetadataFile build() {
        EditableMetadataFile buildable = new EditableMetadataFile(this.fluent.getFieldRef(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataFileBuilder that = (MetadataFileBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

