/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableNamedRoleBinding;
import io.fabric8.openshift.api.model.NamedRoleBinding;
import io.fabric8.openshift.api.model.NamedRoleBindingFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamedRoleBindingBuilder
extends NamedRoleBindingFluent<NamedRoleBindingBuilder>
implements VisitableBuilder<NamedRoleBinding, NamedRoleBindingBuilder> {
    NamedRoleBindingFluent<?> fluent;

    public NamedRoleBindingBuilder() {
        this(new NamedRoleBinding());
    }

    public NamedRoleBindingBuilder(NamedRoleBindingFluent<?> fluent) {
        this(fluent, new NamedRoleBinding());
    }

    public NamedRoleBindingBuilder(NamedRoleBindingFluent<?> fluent, NamedRoleBinding instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withRoleBinding(instance.getRoleBinding());
    }

    public NamedRoleBindingBuilder(NamedRoleBinding instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withRoleBinding(instance.getRoleBinding());
    }

    public EditableNamedRoleBinding build() {
        EditableNamedRoleBinding buildable = new EditableNamedRoleBinding(this.fluent.getName(), this.fluent.getRoleBinding());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedRoleBindingBuilder that = (NamedRoleBindingBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

