/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.SourceRevision;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"output", "resources", "revision", "serviceAccount", "source", "strategy", "triggers"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class BuildConfigSpec {
    @JsonProperty(value="output")
    @Valid
    private BuildOutput output;
    @JsonProperty(value="resources")
    @Valid
    private ResourceRequirements resources;
    @JsonProperty(value="revision")
    @Valid
    private SourceRevision revision;
    @JsonProperty(value="serviceAccount")
    private String serviceAccount;
    @JsonProperty(value="source")
    @Valid
    private BuildSource source;
    @JsonProperty(value="strategy")
    @Valid
    private BuildStrategy strategy;
    @JsonProperty(value="triggers")
    @Valid
    private List<BuildTriggerPolicy> triggers = new ArrayList<BuildTriggerPolicy>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildConfigSpec() {
    }

    public BuildConfigSpec(BuildOutput output, ResourceRequirements resources, SourceRevision revision, String serviceAccount, BuildSource source, BuildStrategy strategy, List<BuildTriggerPolicy> triggers) {
        this.output = output;
        this.resources = resources;
        this.revision = revision;
        this.serviceAccount = serviceAccount;
        this.source = source;
        this.strategy = strategy;
        this.triggers = triggers;
    }

    @JsonProperty(value="output")
    public BuildOutput getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    public void setOutput(BuildOutput output) {
        this.output = output;
    }

    @JsonProperty(value="resources")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @JsonProperty(value="revision")
    public SourceRevision getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    public void setRevision(SourceRevision revision) {
        this.revision = revision;
    }

    @JsonProperty(value="serviceAccount")
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="serviceAccount")
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    @JsonProperty(value="source")
    public BuildSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(BuildSource source) {
        this.source = source;
    }

    @JsonProperty(value="strategy")
    public BuildStrategy getStrategy() {
        return this.strategy;
    }

    @JsonProperty(value="strategy")
    public void setStrategy(BuildStrategy strategy) {
        this.strategy = strategy;
    }

    @JsonProperty(value="triggers")
    public List<BuildTriggerPolicy> getTriggers() {
        return this.triggers;
    }

    @JsonProperty(value="triggers")
    public void setTriggers(List<BuildTriggerPolicy> triggers) {
        this.triggers = triggers;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "BuildConfigSpec(output=" + this.getOutput() + ", resources=" + this.getResources() + ", revision=" + this.getRevision() + ", serviceAccount=" + this.getServiceAccount() + ", source=" + this.getSource() + ", strategy=" + this.getStrategy() + ", triggers=" + this.getTriggers() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfigSpec)) {
            return false;
        }
        BuildConfigSpec other = (BuildConfigSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BuildOutput this$output = this.getOutput();
        BuildOutput other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        SourceRevision this$revision = this.getRevision();
        SourceRevision other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
            return false;
        }
        String this$serviceAccount = this.getServiceAccount();
        String other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !this$serviceAccount.equals(other$serviceAccount)) {
            return false;
        }
        BuildSource this$source = this.getSource();
        BuildSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        BuildStrategy this$strategy = this.getStrategy();
        BuildStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy)) {
            return false;
        }
        List<BuildTriggerPolicy> this$triggers = this.getTriggers();
        List<BuildTriggerPolicy> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildConfigSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuildOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 0 : ((Object)$output).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 0 : ((Object)$resources).hashCode());
        SourceRevision $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 0 : ((Object)$revision).hashCode());
        String $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 0 : $serviceAccount.hashCode());
        BuildSource $source = this.getSource();
        result = result * 59 + ($source == null ? 0 : ((Object)$source).hashCode());
        BuildStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 0 : ((Object)$strategy).hashCode());
        List<BuildTriggerPolicy> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 0 : ((Object)$triggers).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

