/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.EditableContainerPort;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerPortBuilder
extends ContainerPortFluent<ContainerPortBuilder>
implements VisitableBuilder<ContainerPort, ContainerPortBuilder> {
    ContainerPortFluent<?> fluent;

    public ContainerPortBuilder() {
        this(new ContainerPort());
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent) {
        this(fluent, new ContainerPort());
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance) {
        this.fluent = fluent;
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withHostIP(instance.getHostIP());
        fluent.withHostPort(instance.getHostPort());
        fluent.withName(instance.getName());
        fluent.withProtocol(instance.getProtocol());
    }

    public ContainerPortBuilder(ContainerPort instance) {
        this.fluent = this;
        this.withContainerPort(instance.getContainerPort());
        this.withHostIP(instance.getHostIP());
        this.withHostPort(instance.getHostPort());
        this.withName(instance.getName());
        this.withProtocol(instance.getProtocol());
    }

    public EditableContainerPort build() {
        EditableContainerPort buildable = new EditableContainerPort(this.fluent.getContainerPort(), this.fluent.getHostIP(), this.fluent.getHostPort(), this.fluent.getName(), this.fluent.getProtocol());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerPortBuilder that = (ContainerPortBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

