/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.utils.IOHelpers;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Fail;
import org.assertj.core.api.MapAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodLogsAssert
extends MapAssert<String, String> {
    private static final transient Logger LOG = LoggerFactory.getLogger(PodLogsAssert.class);
    private final String containerName;
    private final Map<String, String> logPrefixes;

    public PodLogsAssert(Map<String, String> actual, String containerName) {
        this(actual, containerName, new HashMap<String, String>());
    }

    public PodLogsAssert(Map<String, String> actual, String containerName, Map<String, String> logPrefixes) {
        super(actual);
        this.containerName = containerName;
        this.logPrefixes = logPrefixes;
        this.writeLogs();
    }

    public PodLogsAssert afterText(String startText) {
        HashMap<String, String> newLogs = new HashMap<String, String>();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        Set entries = ((Map)this.actual).entrySet();
        for (Map.Entry entry : entries) {
            String podName = (String)entry.getKey();
            String value = (String)entry.getValue();
            File file = this.podLogFileName(podName);
            int idx = value.indexOf(startText);
            if (idx < 0) continue;
            int splitIdx = idx + startText.length();
            String remaining = value.substring(splitIdx);
            String prefix = value.substring(0, splitIdx);
            newLogs.put(podName, remaining);
            prefixes.put(podName, prefix);
        }
        return new PodLogsAssert(newLogs, this.containerName, prefixes);
    }

    public void containsText(String ... texts) {
        for (String text : texts) {
            Set entries = ((Map)this.actual).entrySet();
            for (Map.Entry entry : entries) {
                String podName = (String)entry.getKey();
                String value = (String)entry.getValue();
                File file = this.podLogFileName(podName);
                int idx = value.indexOf(text);
                if (idx >= 0) continue;
                Fail.fail((String)("Log of pod " + podName + " in file: " + file + " does not contains text `" + text + "` at " + this.logFileCoords(podName, value, idx)));
            }
        }
    }

    public void doesNotContainText(String ... texts) {
        for (String text : texts) {
            Set entries = ((Map)this.actual).entrySet();
            for (Map.Entry entry : entries) {
                String podName = (String)entry.getKey();
                String value = (String)entry.getValue();
                File file = this.podLogFileName(podName);
                int idx = value.indexOf(text);
                if (idx >= 0) {
                    Fail.fail((String)("Log of pod " + podName + " in file: " + file + " contains text `" + text + "` at " + this.logFileCoords(podName, value, idx)));
                    continue;
                }
                LOG.debug("does not contain '" + text + "' in  Log of pod " + podName + " in file: " + file);
            }
        }
    }

    public void doesNotContainTextCount(int count, String ... texts) {
        if (count == 1) {
            this.doesNotContainText(texts);
        }
        for (String text : texts) {
            Set entries = ((Map)this.actual).entrySet();
            for (Map.Entry entry : entries) {
                String podName = (String)entry.getKey();
                String value = (String)entry.getValue();
                File file = this.podLogFileName(podName);
                int idx = 0;
                for (int i = 0; idx >= 0 && i < count; ++i) {
                    int next = value.indexOf(text, idx);
                    idx = next >= 0 ? next + 1 : next;
                }
                if (idx >= 0) {
                    String logText = this.fullLogText(podName, value.substring(0, idx - 1));
                    Fail.fail((String)("Log of pod " + podName + " in file: " + file + " contains text `" + text + "` " + count + " times with the last at at " + PodLogsAssert.textCoords(logText)));
                    continue;
                }
                LOG.debug("does not contain '" + text + "' in Log of pod " + podName + " in file: " + file + " " + count + " times");
            }
        }
    }

    protected String logFileCoords(String podName, String value, int idx) {
        String prefix = "";
        if (value != null && value.length() > 0 && idx > 0) {
            prefix = value.substring(0, idx);
        }
        String logText = this.fullLogText(podName, prefix);
        return PodLogsAssert.textCoords(logText);
    }

    protected String fullLogText(String podName, String text) {
        String logText = text;
        String logPrefix = this.logPrefixes.get(podName);
        if (logPrefix != null) {
            logText = logPrefix + logText;
        }
        return logText;
    }

    public static String textCoords(String text) {
        int next;
        int line = 1;
        int idx = 0;
        while ((next = text.indexOf(10, idx)) >= 0) {
            idx = next + 1;
            ++line;
        }
        int column = 1 + text.length() - idx;
        return "" + line + ":" + column;
    }

    protected File podLogFileName(String podName) {
        String basedir = System.getProperty("basedir", ".");
        File dir = new File(basedir, "target/fabric8/systest/logs");
        String name = podName;
        if (this.containerName != null) {
            name = name + "." + this.containerName;
        }
        name = name + ".log";
        File answer = new File(dir, name);
        answer.getParentFile().mkdirs();
        return answer;
    }

    private void writeLogs() {
        Set entries = ((Map)this.actual).entrySet();
        for (Map.Entry entry : entries) {
            String podName = (String)entry.getKey();
            String value = (String)entry.getValue();
            String logText = this.fullLogText(podName, value);
            File file = this.podLogFileName(podName);
            try {
                IOHelpers.writeFully((File)file, (String)logText);
            }
            catch (IOException e) {
                LOG.error("Failed to write log of pod " + podName + " container:" + this.containerName + " to file: " + file + ". " + e, (Throwable)e);
            }
        }
    }
}

