/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceAccountFluent<T extends ServiceAccountFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ServiceAccount.ApiVersion apiVersion;
    List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<ObjectReference, ?>> secrets = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ServiceAccount.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ServiceAccount.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public T addToImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.remove((Object)builder);
            this.imagePullSecrets.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<LocalObjectReference> getImagePullSecrets() {
        return this.build(this.imagePullSecrets);
    }

    public T withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)((Object)this);
    }

    public T withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)((Object)this);
    }

    public ImagePullSecretsNested<T> addNewImagePullSecret() {
        return new ImagePullSecretsNested();
    }

    public ImagePullSecretsNested<T> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNested(item);
    }

    public T addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T addToSecrets(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromSecrets(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove((Object)builder);
            this.secrets.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<ObjectReference> getSecrets() {
        return this.build(this.secrets);
    }

    public T withSecrets(List<ObjectReference> secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (T)((Object)this);
    }

    public T withSecrets(ObjectReference ... secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (T)((Object)this);
    }

    public SecretsNested<T> addNewSecret() {
        return new SecretsNested();
    }

    public SecretsNested<T> addNewSecretLike(ObjectReference item) {
        return new SecretsNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountFluent that = (ServiceAccountFluent)((Object)o);
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretsNested<N>
    extends ObjectReferenceFluent<SecretsNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        SecretsNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        SecretsNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ServiceAccountFluent.this.addToSecrets(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
            return (N)ServiceAccountFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ImagePullSecretsNested<N>
    extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        ImagePullSecretsNested() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        ImagePullSecretsNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ServiceAccountFluent.this.addToImagePullSecrets(this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }
}

