/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildConfigListFluent<T extends BuildConfigListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    BuildConfigList.ApiVersion apiVersion;
    List<VisitableBuilder<BuildConfig, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildConfigList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(BuildConfigList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public T addToItems(BuildConfig ... items) {
        for (BuildConfig item : items) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromItems(BuildConfig ... items) {
        for (BuildConfig item : items) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<BuildConfig> getItems() {
        return this.build(this.items);
    }

    public T withItems(List<BuildConfig> items) {
        this.items.clear();
        if (items != null) {
            for (BuildConfig item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public T withItems(BuildConfig ... items) {
        this.items.clear();
        if (items != null) {
            for (BuildConfig item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public ItemsNested<T> addNewItem() {
        return new ItemsNested();
    }

    public ItemsNested<T> addNewItemLike(BuildConfig item) {
        return new ItemsNested(item);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BuildConfigListFluent that = (BuildConfigListFluent)((Object)o);
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNested() {
            this.builder = new ListMetaBuilder(this);
        }

        public N and() {
            return (N)BuildConfigListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNested<N>
    extends BuildConfigFluent<ItemsNested<N>>
    implements Nested<N> {
        private final BuildConfigBuilder builder;

        ItemsNested() {
            this.builder = new BuildConfigBuilder(this);
        }

        ItemsNested(BuildConfig item) {
            this.builder = new BuildConfigBuilder(this, item);
        }

        public N endItem() {
            return this.and();
        }

        public N and() {
            return (N)BuildConfigListFluent.this.addToItems(this.builder.build());
        }
    }
}

