/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ReplicationControllerCondition;
import io.fabric8.kubernetes.api.model.ReplicationControllerConditionAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractReplicationControllerStatusAssert<S extends AbstractReplicationControllerStatusAssert<S, A>, A extends ReplicationControllerStatus>
extends AbstractAssert<S, A> {
    protected AbstractReplicationControllerStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((ReplicationControllerStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasAvailableReplicas(Integer availableReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting availableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualAvailableReplicas = ((ReplicationControllerStatus)this.actual).getAvailableReplicas();
        if (!Objects.areEqual((Object)actualAvailableReplicas, (Object)availableReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, availableReplicas, actualAvailableReplicas});
        }
        return (S)((Object)((AbstractReplicationControllerStatusAssert)this.myself));
    }

    public NavigationListAssert<ReplicationControllerCondition, ReplicationControllerConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<ReplicationControllerCondition, ReplicationControllerConditionAssert> assertFactory = new AssertFactory<ReplicationControllerCondition, ReplicationControllerConditionAssert>(){

            @Override
            public ReplicationControllerConditionAssert createAssert(ReplicationControllerCondition t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<ReplicationControllerCondition, ReplicationControllerConditionAssert> answer = new NavigationListAssert<ReplicationControllerCondition, ReplicationControllerConditionAssert>(((ReplicationControllerStatus)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public S hasFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fullyLabeledReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualFullyLabeledReplicas = ((ReplicationControllerStatus)this.actual).getFullyLabeledReplicas();
        if (!Objects.areEqual((Object)actualFullyLabeledReplicas, (Object)fullyLabeledReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fullyLabeledReplicas, actualFullyLabeledReplicas});
        }
        return (S)((Object)((AbstractReplicationControllerStatusAssert)this.myself));
    }

    public S hasObservedGeneration(Long observedGeneration) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualObservedGeneration = ((ReplicationControllerStatus)this.actual).getObservedGeneration();
        if (!Objects.areEqual((Object)actualObservedGeneration, (Object)observedGeneration)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, observedGeneration, actualObservedGeneration});
        }
        return (S)((Object)((AbstractReplicationControllerStatusAssert)this.myself));
    }

    public S hasReadyReplicas(Integer readyReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting readyReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReadyReplicas = ((ReplicationControllerStatus)this.actual).getReadyReplicas();
        if (!Objects.areEqual((Object)actualReadyReplicas, (Object)readyReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, readyReplicas, actualReadyReplicas});
        }
        return (S)((Object)((AbstractReplicationControllerStatusAssert)this.myself));
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((ReplicationControllerStatus)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractReplicationControllerStatusAssert)this.myself));
    }
}

