/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluentImpl;

public class StatefulSetBuilder
extends StatefulSetFluentImpl<StatefulSetBuilder>
implements VisitableBuilder<StatefulSet, StatefulSetBuilder> {
    StatefulSetFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetBuilder() {
        this(true);
    }

    public StatefulSetBuilder(Boolean validationEnabled) {
        this(new StatefulSet(), validationEnabled);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSet(), validationEnabled);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, StatefulSet instance) {
        this(fluent, instance, true);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, StatefulSet instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetBuilder(StatefulSet instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetBuilder(StatefulSet instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSet build() {
        StatefulSet buildable = new StatefulSet(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetBuilder that = (StatefulSetBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

