/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.CronJobStatus;
import io.fabric8.kubernetes.api.model.CronJobStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CronJobStatusFluentImpl<A extends CronJobStatusFluent<A>>
extends BaseFluent<A>
implements CronJobStatusFluent<A> {
    private List<ObjectReferenceBuilder> active = new ArrayList<ObjectReferenceBuilder>();
    private String lastScheduleTime;

    public CronJobStatusFluentImpl() {
    }

    public CronJobStatusFluentImpl(CronJobStatus instance) {
        this.withActive(instance.getActive());
        this.withLastScheduleTime(instance.getLastScheduleTime());
    }

    @Override
    public A addToActive(int index, ObjectReference item) {
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.active.add(index >= 0 ? index : this.active.size(), builder);
        return (A)this;
    }

    @Override
    public A setToActive(int index, ObjectReference item) {
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.active.size()) {
            this.active.add(builder);
        } else {
            this.active.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToActive(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToActive(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromActive(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromActive(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getActive() {
        return CronJobStatusFluentImpl.build(this.active);
    }

    @Override
    public List<ObjectReference> buildActive() {
        return CronJobStatusFluentImpl.build(this.active);
    }

    @Override
    public ObjectReference buildActive(int index) {
        return this.active.get(index).build();
    }

    @Override
    public ObjectReference buildFirstActive() {
        return this.active.get(0).build();
    }

    @Override
    public ObjectReference buildLastActive() {
        return this.active.get(this.active.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.active) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withActive(List<ObjectReference> active) {
        this._visitables.removeAll(this.active);
        this.active.clear();
        if (active != null) {
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withActive(ObjectReference ... active) {
        this.active.clear();
        if (active != null) {
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> addNewActive() {
        return new ActiveNestedImpl();
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> addNewActiveLike(ObjectReference item) {
        return new ActiveNestedImpl(-1, item);
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> setNewActiveLike(int index, ObjectReference item) {
        return new ActiveNestedImpl(index, item);
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editActive(int index) {
        if (this.active.size() <= index) {
            throw new RuntimeException("Can't edit active. Index exceeds size.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editFirstActive() {
        if (this.active.size() == 0) {
            throw new RuntimeException("Can't edit first active. The list is empty.");
        }
        return this.setNewActiveLike(0, this.buildActive(0));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editLastActive() {
        int index = this.active.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last active. The list is empty.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.active.size(); ++i) {
            if (!predicate.apply((Object)this.active.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching active. No match found.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public String getLastScheduleTime() {
        return this.lastScheduleTime;
    }

    @Override
    public A withLastScheduleTime(String lastScheduleTime) {
        this.lastScheduleTime = lastScheduleTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastScheduleTime() {
        return this.lastScheduleTime != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobStatusFluentImpl that = (CronJobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        return !(this.lastScheduleTime != null ? !this.lastScheduleTime.equals(that.lastScheduleTime) : that.lastScheduleTime != null);
    }

    public class ActiveNestedImpl<N>
    extends ObjectReferenceFluentImpl<CronJobStatusFluent.ActiveNested<N>>
    implements CronJobStatusFluent.ActiveNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;
        private final int index;

        ActiveNestedImpl(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ActiveNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobStatusFluentImpl.this.setToActive(this.index, this.builder.build());
        }

        @Override
        public N endActive() {
            return this.and();
        }
    }
}

