/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentConfigSpecFluent<T extends DeploymentConfigSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Integer replicas;
    Map<String, String> selector = new HashMap<String, String>();
    VisitableBuilder<DeploymentStrategy, ?> strategy;
    VisitableBuilder<PodTemplateSpec, ?> template;
    List<VisitableBuilder<DeploymentTriggerPolicy, ?>> triggers = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Integer getReplicas() {
        return this.replicas;
    }

    public T withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (T)((Object)this);
    }

    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)((Object)this);
    }

    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? (DeploymentStrategy)this.strategy.build() : null;
    }

    public T withStrategy(DeploymentStrategy strategy) {
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (T)((Object)this);
    }

    public StrategyNested<T> withNewStrategy() {
        return new StrategyNested();
    }

    public StrategyNested<T> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNested(item);
    }

    public StrategyNested<T> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    public T withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (T)((Object)this);
    }

    public TemplateNested<T> withNewTemplate() {
        return new TemplateNested();
    }

    public TemplateNested<T> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<T> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    public T addToTriggers(DeploymentTriggerPolicy ... items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (T)((Object)this);
    }

    public List<DeploymentTriggerPolicy> getTriggers() {
        return this.build(this.triggers);
    }

    public T withTriggers(List<DeploymentTriggerPolicy> triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)((Object)this);
    }

    public T withTriggers(DeploymentTriggerPolicy ... triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)((Object)this);
    }

    public TriggersNested<T> addNewTrigger() {
        return new TriggersNested();
    }

    public TriggersNested<T> addNewTriggerLike(DeploymentTriggerPolicy item) {
        return new TriggersNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class TriggersNested<N>
    extends DeploymentTriggerPolicyFluent<TriggersNested<N>>
    implements Nested<N> {
        private final DeploymentTriggerPolicyBuilder builder;

        TriggersNested() {
            this.builder = new DeploymentTriggerPolicyBuilder(this);
        }

        TriggersNested(DeploymentTriggerPolicy item) {
            this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }

        public N endTrigger() {
            return this.and();
        }

        public N and() {
            return (N)DeploymentConfigSpecFluent.this.addToTriggers(this.builder.build());
        }
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNested() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        public N endTemplate() {
            return this.and();
        }

        public N and() {
            return (N)DeploymentConfigSpecFluent.this.withTemplate(this.builder.build());
        }
    }

    public class StrategyNested<N>
    extends DeploymentStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        private final DeploymentStrategyBuilder builder;

        StrategyNested() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        StrategyNested(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        public N endStrategy() {
            return this.and();
        }

        public N and() {
            return (N)DeploymentConfigSpecFluent.this.withStrategy(this.builder.build());
        }
    }
}

