/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableOAuthClient;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class OAuthClientBuilder
extends OAuthClientFluent<OAuthClientBuilder>
implements VisitableBuilder<OAuthClient, OAuthClientBuilder> {
    OAuthClientFluent<?> fluent;

    public OAuthClientBuilder() {
        this(new OAuthClient());
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent) {
        this(fluent, new OAuthClient());
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRedirectURIs(instance.getRedirectURIs());
        fluent.withRespondWithChallenges(instance.getRespondWithChallenges());
        fluent.withSecret(instance.getSecret());
    }

    public OAuthClientBuilder(OAuthClient instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURIs(instance.getRedirectURIs());
        this.withRespondWithChallenges(instance.getRespondWithChallenges());
        this.withSecret(instance.getSecret());
    }

    public EditableOAuthClient build() {
        EditableOAuthClient buildable = new EditableOAuthClient(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRedirectURIs(), this.fluent.isRespondWithChallenges(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

