/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildConfigListFluent;
import io.fabric8.openshift.api.model.BuildConfigListFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildConfigListBuilder
extends BuildConfigListFluentImpl<BuildConfigListBuilder>
implements VisitableBuilder<BuildConfigList, BuildConfigListBuilder> {
    BuildConfigListFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConfigListBuilder() {
        this(true);
    }

    public BuildConfigListBuilder(Boolean validationEnabled) {
        this(new BuildConfigList(), validationEnabled);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildConfigList(), validationEnabled);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent, BuildConfigList instance) {
        this(fluent, instance, true);
    }

    public BuildConfigListBuilder(BuildConfigListFluent<?> fluent, BuildConfigList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigListBuilder(BuildConfigList instance) {
        this(instance, (Boolean)true);
    }

    public BuildConfigListBuilder(BuildConfigList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigList build() {
        BuildConfigList buildable = new BuildConfigList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigListBuilder that = (BuildConfigListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

