/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSet;
import io.fabric8.kubernetes.api.model.extensions.PetSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSetList;
import io.fabric8.kubernetes.api.model.extensions.PetSetListFluent;
import java.util.ArrayList;
import java.util.List;

public class PetSetListFluentImpl<A extends PetSetListFluent<A>>
extends BaseFluent<A>
implements PetSetListFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends PetSet, ?>> items = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ListMeta, ?> metadata;

    public PetSetListFluentImpl() {
    }

    public PetSetListFluentImpl(PetSetList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(PetSet ... items) {
        for (PetSet item : items) {
            PetSetBuilder builder = new PetSetBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(PetSet ... items) {
        for (PetSet item : items) {
            PetSetBuilder builder = new PetSetBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<PetSet> getItems() {
        return PetSetListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<PetSet> items) {
        this.items.clear();
        if (items != null) {
            for (PetSet item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(PetSet ... items) {
        this.items.clear();
        if (items != null) {
            for (PetSet item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public PetSetListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public PetSetListFluent.ItemsNested<A> addNewItemLike(PetSet item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PetSetListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PetSetListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PetSetListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PetSetListFluentImpl that = (PetSetListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<PetSetListFluent.MetadataNested<N>>
    implements PetSetListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PetSetListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends PetSetFluentImpl<PetSetListFluent.ItemsNested<N>>
    implements PetSetListFluent.ItemsNested<N>,
    Nested<N> {
        private final PetSetBuilder builder;

        ItemsNestedImpl() {
            this.builder = new PetSetBuilder(this);
        }

        ItemsNestedImpl(PetSet item) {
            this.builder = new PetSetBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PetSetListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

