/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>>
extends BaseFluent<A>
implements IngressBackendFluent<A> {
    private String serviceName;
    private VisitableBuilder<? extends IntOrString, ?> servicePort;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(IngressBackend instance) {
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public IntOrString getServicePort() {
        return this.servicePort != null ? (IntOrString)this.servicePort.build() : null;
    }

    @Override
    public A withServicePort(IntOrString servicePort) {
        if (servicePort != null) {
            this.servicePort = new IntOrStringBuilder(servicePort);
            this._visitables.add(this.servicePort);
        }
        return (A)this;
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePort() {
        return new ServicePortNestedImpl();
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item) {
        return new ServicePortNestedImpl(item);
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editServicePort() {
        return this.withNewServicePortLike(this.getServicePort());
    }

    @Override
    public A withNewServicePort(String strVal) {
        return this.withServicePort(new IntOrString(strVal));
    }

    @Override
    public A withNewServicePort(Integer intVal) {
        return this.withServicePort(new IntOrString(intVal));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendFluentImpl that = (IngressBackendFluentImpl)o;
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        return !(this.servicePort != null ? !this.servicePort.equals(that.servicePort) : that.servicePort != null);
    }

    public class ServicePortNestedImpl<N>
    extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>>
    implements IngressBackendFluent.ServicePortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        ServicePortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        ServicePortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluentImpl.this.withServicePort(this.builder.build());
        }

        @Override
        public N endServicePort() {
            return this.and();
        }
    }
}

