/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamedAuthInfoBuilder
extends NamedAuthInfoFluentImpl<NamedAuthInfoBuilder>
implements VisitableBuilder<NamedAuthInfo, NamedAuthInfoBuilder> {
    NamedAuthInfoFluent<?> fluent;
    Boolean validationEnabled;

    public NamedAuthInfoBuilder() {
        this(true);
    }

    public NamedAuthInfoBuilder(Boolean validationEnabled) {
        this(new NamedAuthInfo(), validationEnabled);
    }

    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedAuthInfo(), validationEnabled);
    }

    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent, NamedAuthInfo instance) {
        this(fluent, instance, true);
    }

    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent, NamedAuthInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public NamedAuthInfoBuilder(NamedAuthInfo instance) {
        this(instance, (Boolean)true);
    }

    public NamedAuthInfoBuilder(NamedAuthInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public NamedAuthInfo build() {
        NamedAuthInfo buildable = new NamedAuthInfo(this.fluent.getName(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedAuthInfoBuilder that = (NamedAuthInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

