/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.DockerConfig;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractDockerConfigAssert<S extends AbstractDockerConfigAssert<S, A>, A extends DockerConfig>
extends AbstractAssert<S, A> {
    protected AbstractDockerConfigAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DockerConfig)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public BooleanAssert attachStderr() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DockerConfig)this.actual).getAttachStderr()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachStderr"), new Object[0]);
    }

    public BooleanAssert attachStdin() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DockerConfig)this.actual).getAttachStdin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachStdin"), new Object[0]);
    }

    public BooleanAssert attachStdout() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DockerConfig)this.actual).getAttachStdout()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachStdout"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> cmd() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((DockerConfig)this.actual).getCmd(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cmd"), new Object[0]);
        return answer;
    }

    public S hasCpuShares(Long cpuShares) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting cpuShares of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualCpuShares = ((DockerConfig)this.actual).getCpuShares();
        if (!Objects.areEqual((Object)actualCpuShares, (Object)cpuShares)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, cpuShares, actualCpuShares});
        }
        return (S)((Object)((AbstractDockerConfigAssert)this.myself));
    }

    public StringAssert cpuset() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((DockerConfig)this.actual).getCpuset()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cpuset"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> dns() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((DockerConfig)this.actual).getDns(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dns"), new Object[0]);
        return answer;
    }

    public StringAssert domainname() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((DockerConfig)this.actual).getDomainname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "domainname"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> entrypoint() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((DockerConfig)this.actual).getEntrypoint(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "entrypoint"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<String, StringAssert> env() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((DockerConfig)this.actual).getEnv(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"), new Object[0]);
        return answer;
    }

    public MapAssert exposedPorts() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DockerConfig)this.actual).getExposedPorts()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "exposedPorts"), new Object[0]);
    }

    public StringAssert hostname() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((DockerConfig)this.actual).getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"), new Object[0]);
    }

    public StringAssert image() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((DockerConfig)this.actual).getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"), new Object[0]);
    }

    public MapAssert labels() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DockerConfig)this.actual).getLabels()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labels"), new Object[0]);
    }

    public S hasMemory(Long memory) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting memory of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualMemory = ((DockerConfig)this.actual).getMemory();
        if (!Objects.areEqual((Object)actualMemory, (Object)memory)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, memory, actualMemory});
        }
        return (S)((Object)((AbstractDockerConfigAssert)this.myself));
    }

    public S hasMemorySwap(Long memorySwap) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting memorySwap of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualMemorySwap = ((DockerConfig)this.actual).getMemorySwap();
        if (!Objects.areEqual((Object)actualMemorySwap, (Object)memorySwap)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, memorySwap, actualMemorySwap});
        }
        return (S)((Object)((AbstractDockerConfigAssert)this.myself));
    }

    public BooleanAssert networkDisabled() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DockerConfig)this.actual).getNetworkDisabled()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "networkDisabled"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> onBuild() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((DockerConfig)this.actual).getOnBuild(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "onBuild"), new Object[0]);
        return answer;
    }

    public BooleanAssert openStdin() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DockerConfig)this.actual).getOpenStdin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openStdin"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> portSpecs() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((DockerConfig)this.actual).getPortSpecs(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "portSpecs"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<String, StringAssert> securityOpts() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((DockerConfig)this.actual).getSecurityOpts(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityOpts"), new Object[0]);
        return answer;
    }

    public BooleanAssert stdinOnce() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DockerConfig)this.actual).getStdinOnce()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "stdinOnce"), new Object[0]);
    }

    public BooleanAssert tty() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DockerConfig)this.actual).getTty()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tty"), new Object[0]);
    }

    public StringAssert user() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((DockerConfig)this.actual).getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"), new Object[0]);
    }

    public MapAssert volumes() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DockerConfig)this.actual).getVolumes()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"), new Object[0]);
    }

    public StringAssert volumesFrom() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((DockerConfig)this.actual).getVolumesFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumesFrom"), new Object[0]);
    }

    public StringAssert workingDir() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((DockerConfig)this.actual).getWorkingDir()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "workingDir"), new Object[0]);
    }
}

