/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.ResourceQuotaListFluent;
import java.util.ArrayList;
import java.util.List;

public class ResourceQuotaListFluentImpl<A extends ResourceQuotaListFluent<A>>
extends BaseFluent<A>
implements ResourceQuotaListFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends ResourceQuota, ?>> items = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ListMeta, ?> metadata;

    public ResourceQuotaListFluentImpl() {
    }

    public ResourceQuotaListFluentImpl(ResourceQuotaList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(ResourceQuota ... items) {
        for (ResourceQuota item : items) {
            ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ResourceQuota ... items) {
        for (ResourceQuota item : items) {
            ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ResourceQuota> getItems() {
        return ResourceQuotaListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<ResourceQuota> items) {
        this.items.clear();
        if (items != null) {
            for (ResourceQuota item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(ResourceQuota ... items) {
        this.items.clear();
        if (items != null) {
            for (ResourceQuota item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public ResourceQuotaListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ResourceQuotaListFluent.ItemsNested<A> addNewItemLike(ResourceQuota item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ResourceQuotaListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ResourceQuotaListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ResourceQuotaListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaListFluentImpl that = (ResourceQuotaListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<ResourceQuotaListFluent.MetadataNested<N>>
    implements ResourceQuotaListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends ResourceQuotaFluentImpl<ResourceQuotaListFluent.ItemsNested<N>>
    implements ResourceQuotaListFluent.ItemsNested<N>,
    Nested<N> {
        private final ResourceQuotaBuilder builder;

        ItemsNestedImpl() {
            this.builder = new ResourceQuotaBuilder(this);
        }

        ItemsNestedImpl(ResourceQuota item) {
            this.builder = new ResourceQuotaBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ResourceQuotaListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

