/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent;
import java.util.ArrayList;
import java.util.List;

public class IngressTLSFluentImpl<A extends IngressTLSFluent<A>>
extends BaseFluent<A>
implements IngressTLSFluent<A> {
    private List<String> hosts = new ArrayList<String>();
    private String secretName;

    public IngressTLSFluentImpl() {
    }

    public IngressTLSFluentImpl(IngressTLS instance) {
        this.withHosts(instance.getHosts());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public A addToHosts(String ... items) {
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public A withHosts(List<String> hosts) {
        this.hosts.clear();
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        this.hosts.clear();
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressTLSFluentImpl that = (IngressTLSFluentImpl)o;
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        return !(this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null);
    }
}

