/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions.support;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.assertions.support.PodWatcher;
import java.util.Timer;
import java.util.TimerTask;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodAsserter {
    private static final transient Logger LOG = LoggerFactory.getLogger(PodAsserter.class);
    private final PodWatcher watcher;
    private final String name;
    private final Pod pod;
    private Timer timer;
    private TimerTask task = new TimerTask(){

        @Override
        public void run() {
            PodAsserter.this.watcher.podIsReadyForEntireDuration(PodAsserter.this.name, PodAsserter.this.pod);
        }
    };

    public PodAsserter(PodWatcher watcher, String name, Pod pod) {
        this.watcher = watcher;
        this.name = name;
        this.pod = pod;
        this.updated(pod);
    }

    public void close() {
        this.cancelTimer();
    }

    public void updated(Pod pod) {
        String statusText = KubernetesHelper.getPodStatusText((Pod)pod);
        boolean ready = KubernetesHelper.isPodReady((Pod)pod);
        String message = "Pod " + this.name + " has status: " + statusText + " isReady: " + ready;
        LOG.info(Ansi.ansi().fg(Ansi.Color.YELLOW).a(message).reset().toString());
        if (ready) {
            this.watcher.podIsReady(this.name, pod);
            if (this.timer == null) {
                this.timer = new Timer(this.watcher.getDescription());
                this.timer.schedule(this.task, this.watcher.getReadyPeriodMS());
            }
        } else {
            this.cancelTimer();
        }
    }

    protected void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

