/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressSpecBuilder
extends IngressSpecFluentImpl<IngressSpecBuilder>
implements VisitableBuilder<IngressSpec, IngressSpecBuilder> {
    IngressSpecFluent<?> fluent;

    public IngressSpecBuilder() {
        this(new IngressSpec());
    }

    public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
        this(fluent, new IngressSpec());
    }

    public IngressSpecBuilder(IngressSpecFluent<?> fluent, IngressSpec instance) {
        this.fluent = fluent;
        fluent.withBackend(instance.getBackend());
        fluent.withRules(instance.getRules());
        fluent.withTls(instance.getTls());
    }

    public IngressSpecBuilder(IngressSpec instance) {
        this.fluent = this;
        this.withBackend(instance.getBackend());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
    }

    public IngressSpec build() {
        IngressSpec buildable = new IngressSpec(this.fluent.getBackend(), this.fluent.getRules(), this.fluent.getTls());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecBuilder that = (IngressSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

