/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ReplicaSetStatusBuilder
extends ReplicaSetStatusFluentImpl<ReplicaSetStatusBuilder>
implements VisitableBuilder<ReplicaSetStatus, ReplicaSetStatusBuilder> {
    ReplicaSetStatusFluent<?> fluent;

    public ReplicaSetStatusBuilder() {
        this(new ReplicaSetStatus());
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent) {
        this(fluent, new ReplicaSetStatus());
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent, ReplicaSetStatus instance) {
        this.fluent = fluent;
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReplicas(instance.getReplicas());
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatus instance) {
        this.fluent = this;
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReplicas(instance.getReplicas());
    }

    public ReplicaSetStatus build() {
        ReplicaSetStatus buildable = new ReplicaSetStatus(this.fluent.getFullyLabeledReplicas(), this.fluent.getObservedGeneration(), this.fluent.getReplicas());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicaSetStatusBuilder that = (ReplicaSetStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

