/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent;
import java.util.HashMap;
import java.util.Map;

public class ReplicaSetSpecFluentImpl<T extends ReplicaSetSpecFluent<T>>
extends BaseFluent<T>
implements ReplicaSetSpecFluent<T> {
    Integer replicas;
    VisitableBuilder<LabelSelector, ?> selector;
    VisitableBuilder<PodTemplateSpec, ?> template;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ReplicaSetSpecFluentImpl() {
    }

    public ReplicaSetSpecFluentImpl(ReplicaSetSpec instance) {
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public T withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (T)this;
    }

    @Override
    public LabelSelector getSelector() {
        return this.selector != null ? (LabelSelector)this.selector.build() : null;
    }

    @Override
    public T withSelector(LabelSelector selector) {
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.add(this.selector);
        }
        return (T)this;
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<T> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<T> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<T> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    @Override
    public T withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (T)this;
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<T> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<T> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<T> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaSetSpecFluentImpl that = (ReplicaSetSpecFluentImpl)o;
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<ReplicaSetSpecFluent.TemplateNested<N>>
    implements ReplicaSetSpecFluent.TemplateNested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N endTemplate() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ReplicaSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ReplicaSetSpecFluent.SelectorNested<N>>
    implements ReplicaSetSpecFluent.SelectorNested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N endSelector() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ReplicaSetSpecFluentImpl.this.withSelector(this.builder.build());
        }
    }
}

