/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DaemonSetStatusBuilder
extends DaemonSetStatusFluentImpl<DaemonSetStatusBuilder>
implements VisitableBuilder<DaemonSetStatus, DaemonSetStatusBuilder> {
    DaemonSetStatusFluent<?> fluent;

    public DaemonSetStatusBuilder() {
        this(new DaemonSetStatus());
    }

    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent) {
        this(fluent, new DaemonSetStatus());
    }

    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent, DaemonSetStatus instance) {
        this.fluent = fluent;
        fluent.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
        fluent.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
        fluent.withNumberMisscheduled(instance.getNumberMisscheduled());
    }

    public DaemonSetStatusBuilder(DaemonSetStatus instance) {
        this.fluent = this;
        this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
        this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
        this.withNumberMisscheduled(instance.getNumberMisscheduled());
    }

    public DaemonSetStatus build() {
        DaemonSetStatus buildable = new DaemonSetStatus(this.fluent.getCurrentNumberScheduled(), this.fluent.getDesiredNumberScheduled(), this.fluent.getNumberMisscheduled());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetStatusBuilder that = (DaemonSetStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

