/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.EditableDeploymentRollback;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentRollbackBuilder
extends DeploymentRollbackFluentImpl<DeploymentRollbackBuilder>
implements VisitableBuilder<DeploymentRollback, DeploymentRollbackBuilder> {
    DeploymentRollbackFluent<?> fluent;

    public DeploymentRollbackBuilder() {
        this(new DeploymentRollback());
    }

    public DeploymentRollbackBuilder(DeploymentRollbackFluent<?> fluent) {
        this(fluent, new DeploymentRollback());
    }

    public DeploymentRollbackBuilder(DeploymentRollbackFluent<?> fluent, DeploymentRollback instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withRollbackTo(instance.getRollbackTo());
        fluent.withUpdatedAnnotations(instance.getUpdatedAnnotations());
    }

    public DeploymentRollbackBuilder(DeploymentRollback instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRollbackTo(instance.getRollbackTo());
        this.withUpdatedAnnotations(instance.getUpdatedAnnotations());
    }

    public EditableDeploymentRollback build() {
        EditableDeploymentRollback buildable = new EditableDeploymentRollback(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getRollbackTo(), this.fluent.getUpdatedAnnotations());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentRollbackBuilder that = (DeploymentRollbackBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

