/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceFluent;
import java.util.HashMap;
import java.util.Map;

public class SecretBuildSourceFluentImpl<T extends SecretBuildSourceFluent<T>>
extends BaseFluent<T>
implements SecretBuildSourceFluent<T> {
    String destinationDir;
    VisitableBuilder<LocalObjectReference, ?> secret;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public SecretBuildSourceFluentImpl() {
    }

    public SecretBuildSourceFluentImpl(SecretBuildSource instance) {
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
    }

    @Override
    public String getDestinationDir() {
        return this.destinationDir;
    }

    @Override
    public T withDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
        return (T)this;
    }

    @Override
    public LocalObjectReference getSecret() {
        return this.secret != null ? (LocalObjectReference)this.secret.build() : null;
    }

    @Override
    public T withSecret(LocalObjectReference secret) {
        if (secret != null) {
            this.secret = new LocalObjectReferenceBuilder(secret);
            this._visitables.add(this.secret);
        }
        return (T)this;
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<T> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<T> withNewSecretLike(LocalObjectReference item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<T> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public T withNewSecret(String name) {
        return this.withSecret(new LocalObjectReference(name));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl)o;
        if (this.destinationDir != null ? !this.destinationDir.equals(that.destinationDir) : that.destinationDir != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretBuildSourceFluent.SecretNested<N>>
    implements SecretBuildSourceFluent.SecretNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecretBuildSourceFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

