/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent;
import java.util.HashMap;
import java.util.Map;

public class IngressBackendFluentImpl<T extends IngressBackendFluent<T>>
extends BaseFluent<T>
implements IngressBackendFluent<T> {
    String serviceName;
    VisitableBuilder<IntOrString, ?> servicePort;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(IngressBackend instance) {
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public T withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (T)this;
    }

    @Override
    public IntOrString getServicePort() {
        return this.servicePort != null ? (IntOrString)this.servicePort.build() : null;
    }

    @Override
    public T withServicePort(IntOrString servicePort) {
        if (servicePort != null) {
            this.servicePort = new IntOrStringBuilder(servicePort);
            this._visitables.add(this.servicePort);
        }
        return (T)this;
    }

    @Override
    public IngressBackendFluent.ServicePortNested<T> withNewServicePort() {
        return new ServicePortNestedImpl();
    }

    @Override
    public IngressBackendFluent.ServicePortNested<T> withNewServicePortLike(IntOrString item) {
        return new ServicePortNestedImpl(item);
    }

    @Override
    public IngressBackendFluent.ServicePortNested<T> editServicePort() {
        return this.withNewServicePortLike(this.getServicePort());
    }

    @Override
    public T withNewServicePort(String strVal) {
        return this.withServicePort(new IntOrString(strVal));
    }

    @Override
    public T withNewServicePort(Integer intVal) {
        return this.withServicePort(new IntOrString(intVal));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressBackendFluentImpl that = (IngressBackendFluentImpl)o;
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.servicePort != null ? !this.servicePort.equals(that.servicePort) : that.servicePort != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ServicePortNestedImpl<N>
    extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>>
    implements IngressBackendFluent.ServicePortNested<N> {
        private final IntOrStringBuilder builder;

        ServicePortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        ServicePortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluentImpl.this.withServicePort(this.builder.build());
        }

        @Override
        public N endServicePort() {
            return this.and();
        }
    }
}

