/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableHTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HTTPGetActionBuilder
extends HTTPGetActionFluentImpl<HTTPGetActionBuilder>
implements VisitableBuilder<HTTPGetAction, HTTPGetActionBuilder> {
    HTTPGetActionFluent<?> fluent;

    public HTTPGetActionBuilder() {
        this(new HTTPGetAction());
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent) {
        this(fluent, new HTTPGetAction());
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, HTTPGetAction instance) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttpHeaders(instance.getHttpHeaders());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withScheme(instance.getScheme());
    }

    public HTTPGetActionBuilder(HTTPGetAction instance) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
    }

    public EditableHTTPGetAction build() {
        EditableHTTPGetAction buildable = new EditableHTTPGetAction(this.fluent.getHost(), this.fluent.getHttpHeaders(), this.fluent.getPath(), this.fluent.getPort(), this.fluent.getScheme());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPGetActionBuilder that = (HTTPGetActionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

