/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.BaseKubernetesList;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.openshift.api.model.template.TemplateBuilder;
import io.fabric8.openshift.api.model.template.TemplateFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseKubernetesListFluent<T extends BaseKubernetesListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    BaseKubernetesList.ApiVersion apiVersion;
    List<HasMetadata> items = new ArrayList<HasMetadata>();
    List<VisitableBuilder<Build, ?>> buildItems = new ArrayList();
    List<VisitableBuilder<BuildConfig, ?>> buildConfigItems = new ArrayList();
    List<VisitableBuilder<BuildRequest, ?>> buildRequestItems = new ArrayList();
    List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigItems = new ArrayList();
    List<VisitableBuilder<Image, ?>> imageItems = new ArrayList();
    List<VisitableBuilder<ImageStream, ?>> imageStreamItems = new ArrayList();
    List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenItems = new ArrayList();
    List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenItems = new ArrayList();
    List<VisitableBuilder<OAuthClient, ?>> oAuthClientItems = new ArrayList();
    List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationItems = new ArrayList();
    List<VisitableBuilder<Route, ?>> routeItems = new ArrayList();
    List<VisitableBuilder<Template, ?>> templateItems = new ArrayList();
    List<VisitableBuilder<Endpoints, ?>> endpointsItems = new ArrayList();
    List<VisitableBuilder<Namespace, ?>> namespaceItems = new ArrayList();
    List<VisitableBuilder<Node, ?>> nodeItems = new ArrayList();
    List<VisitableBuilder<Pod, ?>> podItems = new ArrayList();
    List<VisitableBuilder<ReplicationController, ?>> replicationControllerItems = new ArrayList();
    List<VisitableBuilder<Secret, ?>> secretItems = new ArrayList();
    List<VisitableBuilder<Service, ?>> serviceItems = new ArrayList();
    List<VisitableBuilder<ServiceAccount, ?>> serviceAccountItems = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BaseKubernetesList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(BaseKubernetesList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public T addToItems(HasMetadata item) {
        if (item instanceof Build) {
            this.addToBuildItems((Build)item);
        } else if (item instanceof BuildConfig) {
            this.addToBuildConfigItems((BuildConfig)item);
        } else if (item instanceof BuildRequest) {
            this.addToBuildRequestItems((BuildRequest)item);
        } else if (item instanceof DeploymentConfig) {
            this.addToDeploymentConfigItems((DeploymentConfig)item);
        } else if (item instanceof Image) {
            this.addToImageItems((Image)item);
        } else if (item instanceof ImageStream) {
            this.addToImageStreamItems((ImageStream)item);
        } else if (item instanceof OAuthAccessToken) {
            this.addToOAuthAccessTokenItems((OAuthAccessToken)item);
        } else if (item instanceof OAuthAuthorizeToken) {
            this.addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);
        } else if (item instanceof OAuthClient) {
            this.addToOAuthClientItems((OAuthClient)item);
        } else if (item instanceof OAuthClientAuthorization) {
            this.addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);
        } else if (item instanceof Route) {
            this.addToRouteItems((Route)item);
        } else if (item instanceof Template) {
            this.addToTemplateItems((Template)item);
        } else if (item instanceof Endpoints) {
            this.addToEndpointsItems((Endpoints)item);
        } else if (item instanceof Namespace) {
            this.addToNamespaceItems((Namespace)item);
        } else if (item instanceof Node) {
            this.addToNodeItems((Node)item);
        } else if (item instanceof Pod) {
            this.addToPodItems((Pod)item);
        } else if (item instanceof ReplicationController) {
            this.addToReplicationControllerItems((ReplicationController)item);
        } else if (item instanceof Secret) {
            this.addToSecretItems((Secret)item);
        } else if (item instanceof Service) {
            this.addToServiceItems((Service)item);
        } else if (item instanceof ServiceAccount) {
            this.addToServiceAccountItems((ServiceAccount)item);
        }
        return (T)((Object)this);
    }

    public List<HasMetadata> getItems() {
        return this.aggregate(new List[]{this.build(this.buildItems), this.build(this.buildConfigItems), this.build(this.buildRequestItems), this.build(this.deploymentConfigItems), this.build(this.imageItems), this.build(this.imageStreamItems), this.build(this.oAuthAccessTokenItems), this.build(this.oAuthAuthorizeTokenItems), this.build(this.oAuthClientItems), this.build(this.oAuthClientAuthorizationItems), this.build(this.routeItems), this.build(this.templateItems), this.build(this.endpointsItems), this.build(this.namespaceItems), this.build(this.nodeItems), this.build(this.podItems), this.build(this.replicationControllerItems), this.build(this.secretItems), this.build(this.serviceItems), this.build(this.serviceAccountItems)});
    }

    public T withItems(List<HasMetadata> items) {
        this.items.clear();
        if (items != null) {
            for (HasMetadata item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public T addToBuildItems(Build item) {
        if (item != null) {
            BuildBuilder builder = new BuildBuilder(item);
            this._visitables.add(builder);
            this.buildItems.add((VisitableBuilder<Build, ?>)builder);
        }
        return (T)((Object)this);
    }

    public BuildItemsNested<T> addNewBuildItem() {
        return new BuildItemsNested();
    }

    public BuildItemsNested<T> addNewBuildItemLike(Build item) {
        return new BuildItemsNested(item);
    }

    public T addToBuildConfigItems(BuildConfig item) {
        if (item != null) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.add(builder);
            this.buildConfigItems.add((VisitableBuilder<BuildConfig, ?>)builder);
        }
        return (T)((Object)this);
    }

    public BuildConfigItemsNested<T> addNewBuildConfigItem() {
        return new BuildConfigItemsNested();
    }

    public BuildConfigItemsNested<T> addNewBuildConfigItemLike(BuildConfig item) {
        return new BuildConfigItemsNested(item);
    }

    public T addToBuildRequestItems(BuildRequest item) {
        if (item != null) {
            BuildRequestBuilder builder = new BuildRequestBuilder(item);
            this._visitables.add(builder);
            this.buildRequestItems.add((VisitableBuilder<BuildRequest, ?>)builder);
        }
        return (T)((Object)this);
    }

    public BuildRequestItemsNested<T> addNewBuildRequestItem() {
        return new BuildRequestItemsNested();
    }

    public BuildRequestItemsNested<T> addNewBuildRequestItemLike(BuildRequest item) {
        return new BuildRequestItemsNested(item);
    }

    public T addToDeploymentConfigItems(DeploymentConfig item) {
        if (item != null) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.add(builder);
            this.deploymentConfigItems.add((VisitableBuilder<DeploymentConfig, ?>)builder);
        }
        return (T)((Object)this);
    }

    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItem() {
        return new DeploymentConfigItemsNested();
    }

    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItemLike(DeploymentConfig item) {
        return new DeploymentConfigItemsNested(item);
    }

    public T addToImageItems(Image item) {
        if (item != null) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.add(builder);
            this.imageItems.add((VisitableBuilder<Image, ?>)builder);
        }
        return (T)((Object)this);
    }

    public ImageItemsNested<T> addNewImageItem() {
        return new ImageItemsNested();
    }

    public ImageItemsNested<T> addNewImageItemLike(Image item) {
        return new ImageItemsNested(item);
    }

    public T addToImageStreamItems(ImageStream item) {
        if (item != null) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.add(builder);
            this.imageStreamItems.add((VisitableBuilder<ImageStream, ?>)builder);
        }
        return (T)((Object)this);
    }

    public ImageStreamItemsNested<T> addNewImageStreamItem() {
        return new ImageStreamItemsNested();
    }

    public ImageStreamItemsNested<T> addNewImageStreamItemLike(ImageStream item) {
        return new ImageStreamItemsNested(item);
    }

    public T addToOAuthAccessTokenItems(OAuthAccessToken item) {
        if (item != null) {
            OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);
            this._visitables.add(builder);
            this.oAuthAccessTokenItems.add((VisitableBuilder<OAuthAccessToken, ?>)builder);
        }
        return (T)((Object)this);
    }

    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItem() {
        return new OAuthAccessTokenItemsNested();
    }

    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItemLike(OAuthAccessToken item) {
        return new OAuthAccessTokenItemsNested(item);
    }

    public T addToOAuthAuthorizeTokenItems(OAuthAuthorizeToken item) {
        if (item != null) {
            OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);
            this._visitables.add(builder);
            this.oAuthAuthorizeTokenItems.add((VisitableBuilder<OAuthAuthorizeToken, ?>)builder);
        }
        return (T)((Object)this);
    }

    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItem() {
        return new OAuthAuthorizeTokenItemsNested();
    }

    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItemLike(OAuthAuthorizeToken item) {
        return new OAuthAuthorizeTokenItemsNested(item);
    }

    public T addToOAuthClientItems(OAuthClient item) {
        if (item != null) {
            OAuthClientBuilder builder = new OAuthClientBuilder(item);
            this._visitables.add(builder);
            this.oAuthClientItems.add((VisitableBuilder<OAuthClient, ?>)builder);
        }
        return (T)((Object)this);
    }

    public OAuthClientItemsNested<T> addNewOAuthClientItem() {
        return new OAuthClientItemsNested();
    }

    public OAuthClientItemsNested<T> addNewOAuthClientItemLike(OAuthClient item) {
        return new OAuthClientItemsNested(item);
    }

    public T addToOAuthClientAuthorizationItems(OAuthClientAuthorization item) {
        if (item != null) {
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            this._visitables.add(builder);
            this.oAuthClientAuthorizationItems.add((VisitableBuilder<OAuthClientAuthorization, ?>)builder);
        }
        return (T)((Object)this);
    }

    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItem() {
        return new OAuthClientAuthorizationItemsNested();
    }

    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItemLike(OAuthClientAuthorization item) {
        return new OAuthClientAuthorizationItemsNested(item);
    }

    public T addToRouteItems(Route item) {
        if (item != null) {
            RouteBuilder builder = new RouteBuilder(item);
            this._visitables.add(builder);
            this.routeItems.add((VisitableBuilder<Route, ?>)builder);
        }
        return (T)((Object)this);
    }

    public RouteItemsNested<T> addNewRouteItem() {
        return new RouteItemsNested();
    }

    public RouteItemsNested<T> addNewRouteItemLike(Route item) {
        return new RouteItemsNested(item);
    }

    public T addToTemplateItems(Template item) {
        if (item != null) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.add(builder);
            this.templateItems.add((VisitableBuilder<Template, ?>)builder);
        }
        return (T)((Object)this);
    }

    public TemplateItemsNested<T> addNewTemplateItem() {
        return new TemplateItemsNested();
    }

    public TemplateItemsNested<T> addNewTemplateItemLike(Template item) {
        return new TemplateItemsNested(item);
    }

    public T addToEndpointsItems(Endpoints item) {
        if (item != null) {
            EndpointsBuilder builder = new EndpointsBuilder(item);
            this._visitables.add(builder);
            this.endpointsItems.add(builder);
        }
        return (T)((Object)this);
    }

    public EndpointsItemsNested<T> addNewEndpointsItem() {
        return new EndpointsItemsNested();
    }

    public EndpointsItemsNested<T> addNewEndpointsItemLike(Endpoints item) {
        return new EndpointsItemsNested(item);
    }

    public T addToNamespaceItems(Namespace item) {
        if (item != null) {
            NamespaceBuilder builder = new NamespaceBuilder(item);
            this._visitables.add(builder);
            this.namespaceItems.add(builder);
        }
        return (T)((Object)this);
    }

    public NamespaceItemsNested<T> addNewNamespaceItem() {
        return new NamespaceItemsNested();
    }

    public NamespaceItemsNested<T> addNewNamespaceItemLike(Namespace item) {
        return new NamespaceItemsNested(item);
    }

    public T addToNodeItems(Node item) {
        if (item != null) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.add(builder);
            this.nodeItems.add(builder);
        }
        return (T)((Object)this);
    }

    public NodeItemsNested<T> addNewNodeItem() {
        return new NodeItemsNested();
    }

    public NodeItemsNested<T> addNewNodeItemLike(Node item) {
        return new NodeItemsNested(item);
    }

    public T addToPodItems(Pod item) {
        if (item != null) {
            PodBuilder builder = new PodBuilder(item);
            this._visitables.add(builder);
            this.podItems.add(builder);
        }
        return (T)((Object)this);
    }

    public PodItemsNested<T> addNewPodItem() {
        return new PodItemsNested();
    }

    public PodItemsNested<T> addNewPodItemLike(Pod item) {
        return new PodItemsNested(item);
    }

    public T addToReplicationControllerItems(ReplicationController item) {
        if (item != null) {
            ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);
            this._visitables.add(builder);
            this.replicationControllerItems.add(builder);
        }
        return (T)((Object)this);
    }

    public ReplicationControllerItemsNested<T> addNewReplicationControllerItem() {
        return new ReplicationControllerItemsNested();
    }

    public ReplicationControllerItemsNested<T> addNewReplicationControllerItemLike(ReplicationController item) {
        return new ReplicationControllerItemsNested(item);
    }

    public T addToSecretItems(Secret item) {
        if (item != null) {
            SecretBuilder builder = new SecretBuilder(item);
            this._visitables.add(builder);
            this.secretItems.add(builder);
        }
        return (T)((Object)this);
    }

    public SecretItemsNested<T> addNewSecretItem() {
        return new SecretItemsNested();
    }

    public SecretItemsNested<T> addNewSecretItemLike(Secret item) {
        return new SecretItemsNested(item);
    }

    public T addToServiceItems(Service item) {
        if (item != null) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.add(builder);
            this.serviceItems.add(builder);
        }
        return (T)((Object)this);
    }

    public ServiceItemsNested<T> addNewServiceItem() {
        return new ServiceItemsNested();
    }

    public ServiceItemsNested<T> addNewServiceItemLike(Service item) {
        return new ServiceItemsNested(item);
    }

    public T addToServiceAccountItems(ServiceAccount item) {
        if (item != null) {
            ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
            this._visitables.add(builder);
            this.serviceAccountItems.add(builder);
        }
        return (T)((Object)this);
    }

    public ServiceAccountItemsNested<T> addNewServiceAccountItem() {
        return new ServiceAccountItemsNested();
    }

    public ServiceAccountItemsNested<T> addNewServiceAccountItemLike(ServiceAccount item) {
        return new ServiceAccountItemsNested(item);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNested() {
            this.builder = new ListMetaBuilder(this);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ServiceAccountItemsNested<N>
    extends ServiceAccountFluent<ServiceAccountItemsNested<N>>
    implements Nested<N> {
        private final ServiceAccountBuilder builder;

        ServiceAccountItemsNested() {
            this.builder = new ServiceAccountBuilder(this);
        }

        ServiceAccountItemsNested(ServiceAccount item) {
            this.builder = new ServiceAccountBuilder(this, item);
        }

        public N endServiceAccountItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToServiceAccountItems(this.builder.build());
        }
    }

    public class ServiceItemsNested<N>
    extends ServiceFluent<ServiceItemsNested<N>>
    implements Nested<N> {
        private final ServiceBuilder builder;

        ServiceItemsNested() {
            this.builder = new ServiceBuilder(this);
        }

        ServiceItemsNested(Service item) {
            this.builder = new ServiceBuilder(this, item);
        }

        public N endServiceItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToServiceItems(this.builder.build());
        }
    }

    public class SecretItemsNested<N>
    extends SecretFluent<SecretItemsNested<N>>
    implements Nested<N> {
        private final SecretBuilder builder;

        SecretItemsNested(Secret item) {
            this.builder = new SecretBuilder(this, item);
        }

        SecretItemsNested() {
            this.builder = new SecretBuilder(this);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToSecretItems(this.builder.build());
        }

        public N endSecretItem() {
            return this.and();
        }
    }

    public class ReplicationControllerItemsNested<N>
    extends ReplicationControllerFluent<ReplicationControllerItemsNested<N>>
    implements Nested<N> {
        private final ReplicationControllerBuilder builder;

        ReplicationControllerItemsNested(ReplicationController item) {
            this.builder = new ReplicationControllerBuilder(this, item);
        }

        ReplicationControllerItemsNested() {
            this.builder = new ReplicationControllerBuilder(this);
        }

        public N endReplicationControllerItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToReplicationControllerItems(this.builder.build());
        }
    }

    public class PodItemsNested<N>
    extends PodFluent<PodItemsNested<N>>
    implements Nested<N> {
        private final PodBuilder builder;

        PodItemsNested(Pod item) {
            this.builder = new PodBuilder(this, item);
        }

        PodItemsNested() {
            this.builder = new PodBuilder(this);
        }

        public N endPodItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToPodItems(this.builder.build());
        }
    }

    public class NodeItemsNested<N>
    extends NodeFluent<NodeItemsNested<N>>
    implements Nested<N> {
        private final NodeBuilder builder;

        NodeItemsNested(Node item) {
            this.builder = new NodeBuilder(this, item);
        }

        NodeItemsNested() {
            this.builder = new NodeBuilder(this);
        }

        public N endNodeItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToNodeItems(this.builder.build());
        }
    }

    public class NamespaceItemsNested<N>
    extends NamespaceFluent<NamespaceItemsNested<N>>
    implements Nested<N> {
        private final NamespaceBuilder builder;

        NamespaceItemsNested() {
            this.builder = new NamespaceBuilder(this);
        }

        NamespaceItemsNested(Namespace item) {
            this.builder = new NamespaceBuilder(this, item);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToNamespaceItems(this.builder.build());
        }

        public N endNamespaceItem() {
            return this.and();
        }
    }

    public class EndpointsItemsNested<N>
    extends EndpointsFluent<EndpointsItemsNested<N>>
    implements Nested<N> {
        private final EndpointsBuilder builder;

        EndpointsItemsNested() {
            this.builder = new EndpointsBuilder(this);
        }

        EndpointsItemsNested(Endpoints item) {
            this.builder = new EndpointsBuilder(this, item);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToEndpointsItems(this.builder.build());
        }

        public N endEndpointsItem() {
            return this.and();
        }
    }

    public class TemplateItemsNested<N>
    extends TemplateFluent<TemplateItemsNested<N>>
    implements Nested<N> {
        private final TemplateBuilder builder;

        TemplateItemsNested() {
            this.builder = new TemplateBuilder((TemplateFluent)this);
        }

        TemplateItemsNested(Template item) {
            this.builder = new TemplateBuilder((TemplateFluent)this, item);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToTemplateItems(this.builder.build());
        }

        public N endTemplateItem() {
            return this.and();
        }
    }

    public class RouteItemsNested<N>
    extends RouteFluent<RouteItemsNested<N>>
    implements Nested<N> {
        private final RouteBuilder builder;

        RouteItemsNested(Route item) {
            this.builder = new RouteBuilder((RouteFluent)this, item);
        }

        RouteItemsNested() {
            this.builder = new RouteBuilder((RouteFluent)this);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToRouteItems(this.builder.build());
        }

        public N endRouteItem() {
            return this.and();
        }
    }

    public class OAuthClientAuthorizationItemsNested<N>
    extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationItemsNested<N>>
    implements Nested<N> {
        private final OAuthClientAuthorizationBuilder builder;

        OAuthClientAuthorizationItemsNested(OAuthClientAuthorization item) {
            this.builder = new OAuthClientAuthorizationBuilder((OAuthClientAuthorizationFluent)this, item);
        }

        OAuthClientAuthorizationItemsNested() {
            this.builder = new OAuthClientAuthorizationBuilder((OAuthClientAuthorizationFluent)this);
        }

        public N endOAuthClientAuthorizationItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthClientAuthorizationItems(this.builder.build());
        }
    }

    public class OAuthClientItemsNested<N>
    extends OAuthClientFluent<OAuthClientItemsNested<N>>
    implements Nested<N> {
        private final OAuthClientBuilder builder;

        OAuthClientItemsNested() {
            this.builder = new OAuthClientBuilder((OAuthClientFluent)this);
        }

        OAuthClientItemsNested(OAuthClient item) {
            this.builder = new OAuthClientBuilder((OAuthClientFluent)this, item);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthClientItems(this.builder.build());
        }

        public N endOAuthClientItem() {
            return this.and();
        }
    }

    public class OAuthAuthorizeTokenItemsNested<N>
    extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenItemsNested<N>>
    implements Nested<N> {
        private final OAuthAuthorizeTokenBuilder builder;

        OAuthAuthorizeTokenItemsNested(OAuthAuthorizeToken item) {
            this.builder = new OAuthAuthorizeTokenBuilder((OAuthAuthorizeTokenFluent)this, item);
        }

        OAuthAuthorizeTokenItemsNested() {
            this.builder = new OAuthAuthorizeTokenBuilder((OAuthAuthorizeTokenFluent)this);
        }

        public N endOAuthAuthorizeTokenItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthAuthorizeTokenItems(this.builder.build());
        }
    }

    public class OAuthAccessTokenItemsNested<N>
    extends OAuthAccessTokenFluent<OAuthAccessTokenItemsNested<N>>
    implements Nested<N> {
        private final OAuthAccessTokenBuilder builder;

        OAuthAccessTokenItemsNested(OAuthAccessToken item) {
            this.builder = new OAuthAccessTokenBuilder((OAuthAccessTokenFluent)this, item);
        }

        OAuthAccessTokenItemsNested() {
            this.builder = new OAuthAccessTokenBuilder((OAuthAccessTokenFluent)this);
        }

        public N endOAuthAccessTokenItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthAccessTokenItems(this.builder.build());
        }
    }

    public class ImageStreamItemsNested<N>
    extends ImageStreamFluent<ImageStreamItemsNested<N>>
    implements Nested<N> {
        private final ImageStreamBuilder builder;

        ImageStreamItemsNested(ImageStream item) {
            this.builder = new ImageStreamBuilder((ImageStreamFluent)this, item);
        }

        ImageStreamItemsNested() {
            this.builder = new ImageStreamBuilder((ImageStreamFluent)this);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToImageStreamItems(this.builder.build());
        }

        public N endImageStreamItem() {
            return this.and();
        }
    }

    public class ImageItemsNested<N>
    extends ImageFluent<ImageItemsNested<N>>
    implements Nested<N> {
        private final ImageBuilder builder;

        ImageItemsNested() {
            this.builder = new ImageBuilder((ImageFluent)this);
        }

        ImageItemsNested(Image item) {
            this.builder = new ImageBuilder((ImageFluent)this, item);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToImageItems(this.builder.build());
        }

        public N endImageItem() {
            return this.and();
        }
    }

    public class DeploymentConfigItemsNested<N>
    extends DeploymentConfigFluent<DeploymentConfigItemsNested<N>>
    implements Nested<N> {
        private final DeploymentConfigBuilder builder;

        DeploymentConfigItemsNested(DeploymentConfig item) {
            this.builder = new DeploymentConfigBuilder((DeploymentConfigFluent)this, item);
        }

        DeploymentConfigItemsNested() {
            this.builder = new DeploymentConfigBuilder((DeploymentConfigFluent)this);
        }

        public N endDeploymentConfigItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToDeploymentConfigItems(this.builder.build());
        }
    }

    public class BuildRequestItemsNested<N>
    extends BuildRequestFluent<BuildRequestItemsNested<N>>
    implements Nested<N> {
        private final BuildRequestBuilder builder;

        BuildRequestItemsNested(BuildRequest item) {
            this.builder = new BuildRequestBuilder((BuildRequestFluent)this, item);
        }

        BuildRequestItemsNested() {
            this.builder = new BuildRequestBuilder((BuildRequestFluent)this);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToBuildRequestItems(this.builder.build());
        }

        public N endBuildRequestItem() {
            return this.and();
        }
    }

    public class BuildConfigItemsNested<N>
    extends BuildConfigFluent<BuildConfigItemsNested<N>>
    implements Nested<N> {
        private final BuildConfigBuilder builder;

        BuildConfigItemsNested(BuildConfig item) {
            this.builder = new BuildConfigBuilder((BuildConfigFluent)this, item);
        }

        BuildConfigItemsNested() {
            this.builder = new BuildConfigBuilder((BuildConfigFluent)this);
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToBuildConfigItems(this.builder.build());
        }

        public N endBuildConfigItem() {
            return this.and();
        }
    }

    public class BuildItemsNested<N>
    extends BuildFluent<BuildItemsNested<N>>
    implements Nested<N> {
        private final BuildBuilder builder;

        BuildItemsNested() {
            this.builder = new BuildBuilder((BuildFluent)this);
        }

        BuildItemsNested(Build item) {
            this.builder = new BuildBuilder((BuildFluent)this, item);
        }

        public N endBuildItem() {
            return this.and();
        }

        public N and() {
            return (N)BaseKubernetesListFluent.this.addToBuildItems(this.builder.build());
        }
    }
}

