/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeConditionFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeConditionBuilder
extends NodeConditionFluent<NodeConditionBuilder>
implements VisitableBuilder<NodeCondition, NodeConditionBuilder> {
    NodeConditionFluent<?> fluent;

    public NodeConditionBuilder() {
        this(new NodeCondition());
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent) {
        this(fluent, new NodeCondition());
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent, NodeCondition instance) {
        this.fluent = fluent;
        fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime());
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
    }

    public NodeConditionBuilder(NodeCondition instance) {
        this.fluent = this;
        this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
    }

    public NodeCondition build() {
        NodeCondition buildable = new NodeCondition(this.fluent.getLastHeartbeatTime(), this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

