/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointSubsetBuilder
extends EndpointSubsetFluent<EndpointSubsetBuilder>
implements Builder<EndpointSubset> {
    EndpointSubsetFluent<?> fluent;

    public EndpointSubsetBuilder() {
        this(new EndpointSubset());
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent) {
        this(fluent, new EndpointSubset());
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent, EndpointSubset instance) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withPorts(instance.getPorts());
    }

    public EndpointSubsetBuilder(EndpointSubset instance) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withPorts(instance.getPorts());
    }

    public EndpointSubset build() {
        EndpointSubset buildable = new EndpointSubset(this.fluent.getAddresses(), this.fluent.getPorts());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

