/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeMountBuilder
extends VolumeMountFluent<VolumeMountBuilder>
implements Builder<VolumeMount> {
    VolumeMountFluent<?> fluent;

    public VolumeMountBuilder() {
        this(new VolumeMount());
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent) {
        this(fluent, new VolumeMount());
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent, VolumeMount instance) {
        this.fluent = fluent;
        fluent.withMountPath(instance.getMountPath());
        fluent.withName(instance.getName());
        fluent.withReadOnly(instance.getReadOnly());
    }

    public VolumeMountBuilder(VolumeMount instance) {
        this.fluent = this;
        this.withMountPath(instance.getMountPath());
        this.withName(instance.getName());
        this.withReadOnly(instance.getReadOnly());
    }

    public VolumeMount build() {
        VolumeMount buildable = new VolumeMount(this.fluent.getMountPath(), this.fluent.getName(), this.fluent.isReadOnly());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

