/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"emptyDir", "gcePersistentDisk", "gitRepo", "glusterfs", "hostPath", "iscsi", "name", "nfs", "secret"})
public class Volume {
    @JsonProperty(value="emptyDir")
    @Valid
    private EmptyDirVolumeSource emptyDir;
    @JsonProperty(value="gcePersistentDisk")
    @Valid
    private GCEPersistentDiskVolumeSource gcePersistentDisk;
    @JsonProperty(value="gitRepo")
    @Valid
    private GitRepoVolumeSource gitRepo;
    @JsonProperty(value="glusterfs")
    @Valid
    private GlusterfsVolumeSource glusterfs;
    @JsonProperty(value="hostPath")
    @Valid
    private HostPathVolumeSource hostPath;
    @JsonProperty(value="iscsi")
    @Valid
    private ISCSIVolumeSource iscsi;
    @JsonProperty(value="name")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max=63)
    private String name;
    @JsonProperty(value="nfs")
    @Valid
    private NFSVolumeSource nfs;
    @JsonProperty(value="secret")
    @Valid
    private SecretVolumeSource secret;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Volume() {
    }

    public Volume(EmptyDirVolumeSource emptyDir, GCEPersistentDiskVolumeSource gcePersistentDisk, GitRepoVolumeSource gitRepo, GlusterfsVolumeSource glusterfs, HostPathVolumeSource hostPath, ISCSIVolumeSource iscsi, String name, NFSVolumeSource nfs, SecretVolumeSource secret) {
        this.emptyDir = emptyDir;
        this.gcePersistentDisk = gcePersistentDisk;
        this.gitRepo = gitRepo;
        this.glusterfs = glusterfs;
        this.hostPath = hostPath;
        this.iscsi = iscsi;
        this.name = name;
        this.nfs = nfs;
        this.secret = secret;
    }

    @JsonProperty(value="emptyDir")
    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir;
    }

    @JsonProperty(value="emptyDir")
    public void setEmptyDir(EmptyDirVolumeSource emptyDir) {
        this.emptyDir = emptyDir;
    }

    @JsonProperty(value="gcePersistentDisk")
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk;
    }

    @JsonProperty(value="gcePersistentDisk")
    public void setGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this.gcePersistentDisk = gcePersistentDisk;
    }

    @JsonProperty(value="gitRepo")
    public GitRepoVolumeSource getGitRepo() {
        return this.gitRepo;
    }

    @JsonProperty(value="gitRepo")
    public void setGitRepo(GitRepoVolumeSource gitRepo) {
        this.gitRepo = gitRepo;
    }

    @JsonProperty(value="glusterfs")
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs;
    }

    @JsonProperty(value="glusterfs")
    public void setGlusterfs(GlusterfsVolumeSource glusterfs) {
        this.glusterfs = glusterfs;
    }

    @JsonProperty(value="hostPath")
    public HostPathVolumeSource getHostPath() {
        return this.hostPath;
    }

    @JsonProperty(value="hostPath")
    public void setHostPath(HostPathVolumeSource hostPath) {
        this.hostPath = hostPath;
    }

    @JsonProperty(value="iscsi")
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi;
    }

    @JsonProperty(value="iscsi")
    public void setIscsi(ISCSIVolumeSource iscsi) {
        this.iscsi = iscsi;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="nfs")
    public NFSVolumeSource getNfs() {
        return this.nfs;
    }

    @JsonProperty(value="nfs")
    public void setNfs(NFSVolumeSource nfs) {
        this.nfs = nfs;
    }

    @JsonProperty(value="secret")
    public SecretVolumeSource getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    public void setSecret(SecretVolumeSource secret) {
        this.secret = secret;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.emptyDir).append((Object)this.gcePersistentDisk).append((Object)this.gitRepo).append((Object)this.glusterfs).append((Object)this.hostPath).append((Object)this.iscsi).append((Object)this.name).append((Object)this.nfs).append((Object)this.secret).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Volume)) {
            return false;
        }
        Volume rhs = (Volume)other;
        return new EqualsBuilder().append((Object)this.emptyDir, (Object)rhs.emptyDir).append((Object)this.gcePersistentDisk, (Object)rhs.gcePersistentDisk).append((Object)this.gitRepo, (Object)rhs.gitRepo).append((Object)this.glusterfs, (Object)rhs.glusterfs).append((Object)this.hostPath, (Object)rhs.hostPath).append((Object)this.iscsi, (Object)rhs.iscsi).append((Object)this.name, (Object)rhs.name).append((Object)this.nfs, (Object)rhs.nfs).append((Object)this.secret, (Object)rhs.secret).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }
}

