/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.runtime;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RawExtensionBuilder
extends RawExtensionFluent<RawExtensionBuilder>
implements Builder<RawExtension> {
    private final RawExtensionFluent<?> fluent;

    public RawExtensionBuilder() {
        this(new RawExtension());
    }

    public RawExtensionBuilder(RawExtensionFluent<?> fluent) {
        this(fluent, new RawExtension());
    }

    public RawExtensionBuilder(RawExtensionFluent<?> fluent, RawExtension instance) {
        this.fluent = fluent;
        fluent.withRawJSON(instance.getRawJSON());
    }

    public RawExtensionBuilder(RawExtension instance) {
        this.fluent = this;
        this.withRawJSON(instance.getRawJSON());
    }

    public RawExtension build() {
        RawExtension buildable = new RawExtension(this.fluent.getRawJSON());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

