/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ServiceBuilder
extends ServiceFluent<ServiceBuilder>
implements Builder<Service> {
    private final ServiceFluent<?> fluent;

    public ServiceBuilder() {
        this(new Service());
    }

    public ServiceBuilder(ServiceFluent<?> fluent) {
        this(fluent, new Service());
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Service instance) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withCreateExternalLoadBalancer(instance.getCreateExternalLoadBalancer());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withDeletionTimestamp(instance.getDeletionTimestamp());
        fluent.withGenerateName(instance.getGenerateName());
        fluent.withId(instance.getId());
        fluent.withKind(instance.getKind());
        fluent.withLabels(instance.getLabels());
        fluent.withNamespace(instance.getNamespace());
        fluent.withPort(instance.getPort());
        fluent.withPortName(instance.getPortName());
        fluent.withPortalIP(instance.getPortalIP());
        fluent.withPorts(instance.getPorts());
        fluent.withProtocol(instance.getProtocol());
        fluent.withProxyPort(instance.getProxyPort());
        fluent.withPublicIPs(instance.getPublicIPs());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelector(instance.getSelector());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withSessionAffinity(instance.getSessionAffinity());
        fluent.withUid(instance.getUid());
    }

    public ServiceBuilder(Service instance) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withApiVersion(instance.getApiVersion());
        this.withContainerPort(instance.getContainerPort());
        this.withCreateExternalLoadBalancer(instance.getCreateExternalLoadBalancer());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withGenerateName(instance.getGenerateName());
        this.withId(instance.getId());
        this.withKind(instance.getKind());
        this.withLabels(instance.getLabels());
        this.withNamespace(instance.getNamespace());
        this.withPort(instance.getPort());
        this.withPortName(instance.getPortName());
        this.withPortalIP(instance.getPortalIP());
        this.withPorts(instance.getPorts());
        this.withProtocol(instance.getProtocol());
        this.withProxyPort(instance.getProxyPort());
        this.withPublicIPs(instance.getPublicIPs());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelector(instance.getSelector());
        this.withSelfLink(instance.getSelfLink());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withUid(instance.getUid());
    }

    public Service build() {
        Service buildable = new Service(this.fluent.getAnnotations(), this.fluent.getApiVersion(), this.fluent.getContainerPort(), this.fluent.isCreateExternalLoadBalancer(), this.fluent.getCreationTimestamp(), this.fluent.getDeletionTimestamp(), this.fluent.getGenerateName(), this.fluent.getId(), this.fluent.getKind(), this.fluent.getLabels(), this.fluent.getNamespace(), this.fluent.getPort(), this.fluent.getPortName(), this.fluent.getPortalIP(), this.fluent.getPorts(), this.fluent.getProtocol(), this.fluent.getProxyPort(), this.fluent.getPublicIPs(), this.fluent.getResourceVersion(), this.fluent.getSelector(), this.fluent.getSelfLink(), this.fluent.getSessionAffinity(), this.fluent.getUid());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

